/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network.config;

import com.horstmann.violet.framework.network.NetworkConstant;
import com.horstmann.violet.framework.network.config.IHostNetworkConfig;
import com.horstmann.violet.framework.preference.PreferencesConstant;
import com.horstmann.violet.framework.preference.PreferencesService;
import com.horstmann.violet.framework.preference.PreferencesServiceFactory;
import java.net.MalformedURLException;
import java.net.URL;

public class HTTPHostConfig
implements IHostNetworkConfig {
    private String userID;
    private String localIpPort;
    private String localIpAddress;

    @Override
    public void loadPreferedValues() {
        PreferencesService preferencesService = PreferencesServiceFactory.getInstance();
        String userID = preferencesService.get(PreferencesConstant.NETWORK_HOSTCONFIG_USERID, "username");
        String localURL = preferencesService.get(PreferencesConstant.NETWORK_HOSTCONFIG_HTTP_LOCALURL, NetworkConstant.DEFAULT_HTTP_LOCAL_URL.toString());
        this.setUserID(userID);
        try {
            URL url = new URL(localURL);
            this.setLocalIpAddress(url.getHost());
            this.setLocalIpPort(url.getPort() + "");
        }
        catch (MalformedURLException e) {
            this.setLocalIpPort("9090");
        }
    }

    @Override
    public void savePreferedValues() {
        PreferencesService preferencesService = PreferencesServiceFactory.getInstance();
        preferencesService.put(PreferencesConstant.NETWORK_HOSTCONFIG_USERID, this.getUserID());
        preferencesService.put(PreferencesConstant.NETWORK_HOSTCONFIG_HTTP_LOCALURL, this.getLocalURL().toString());
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getLocalIpAddress() {
        return this.localIpAddress;
    }

    public void setLocalIpAddress(String ipAddress) {
        this.localIpAddress = ipAddress;
    }

    public String getLocalIpPort() {
        return this.localIpPort;
    }

    public void setLocalIpPort(String ipPort) {
        this.localIpPort = ipPort;
    }

    @Override
    public URL getLocalURL() {
        try {
            URL url = new URL("http://" + this.getLocalIpAddress() + ":" + this.getLocalIpPort() + "/");
            return url;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error while building local network URL", e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        HTTPHostConfig clone = new HTTPHostConfig();
        String emptyString = "";
        if (this.userID != null) {
            clone.userID = this.userID + emptyString;
        }
        if (this.localIpAddress != null) {
            clone.localIpAddress = this.localIpAddress + emptyString;
        }
        if (this.localIpPort != null) {
            clone.localIpPort = this.localIpPort + emptyString;
        }
        return clone;
    }
}

