/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;

public class StringFilterInputStream
extends FilterInputStream {
    private String originalContent;
    private String filteredContent;
    private int cursor = 0;

    public StringFilterInputStream(InputStream in, Map<String, String> replaceMap) {
        super(in);
        this.originalContent = this.getInputStreamContent(in);
        this.filteredContent = this.getFilteredString(this.originalContent, replaceMap);
    }

    @Override
    public int read() {
        String buffer = this.filteredContent;
        if (buffer != null && this.cursor < buffer.length()) {
            return buffer.charAt(this.cursor++);
        }
        return -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int ok = 0;
        while (len-- > 0) {
            int i = this.read();
            if (i == -1) {
                return ok == 0 ? -1 : ok;
            }
            b[off++] = (byte)i;
            ++ok;
        }
        return ok;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    private String getInputStreamContent(InputStream in) {
        try {
            int numRead;
            InputStreamReader isr = new InputStreamReader(in);
            StringBuffer buffer = new StringBuffer();
            int len = 1024;
            char[] buf = new char[len];
            while ((numRead = isr.read(buf, 0, len)) != -1) {
                buffer.append(buf, 0, numRead);
            }
            isr.close();
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFilteredString(String input, Map<String, String> replaceMap) {
        Set<String> set = replaceMap.keySet();
        for (String searchedStr : set) {
            String replaceStr = replaceMap.get(searchedStr);
            input = input.replaceAll(searchedStr, replaceStr);
        }
        return input;
    }
}

