/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.activity;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.EllipticalNode;
import com.horstmann.violet.framework.diagram.Grid;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ScenarioEndNode
extends EllipticalNode {
    private static int DEFAULT_DIAMETER = 14;
    private static int DEFAULT_GAP = 3;

    public ScenarioEndNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_DIAMETER + 2 * DEFAULT_GAP, DEFAULT_DIAMETER + 2 * DEFAULT_GAP));
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        this.snapBounds(grid, DEFAULT_DIAMETER + 2 * DEFAULT_GAP, DEFAULT_DIAMETER + 2 * DEFAULT_GAP);
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return e.getEnd() != null && this != e.getEnd();
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Ellipse2D.Double circle = new Ellipse2D.Double(this.getBounds().getX(), this.getBounds().getY(), this.getBounds().getWidth(), this.getBounds().getHeight());
        Rectangle2D bounds = this.getBounds();
        Ellipse2D.Double inside = new Ellipse2D.Double(bounds.getX() + (double)DEFAULT_GAP, bounds.getY() + (double)DEFAULT_GAP, bounds.getWidth() - (double)(2 * DEFAULT_GAP), bounds.getHeight() - (double)(2 * DEFAULT_GAP));
        g2.fill(inside);
        g2.draw(circle);
    }
}

