/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.common;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class NoteNode
extends RectangularNode {
    private MultiLineString text;
    private Color color;
    private static int DEFAULT_WIDTH = 60;
    private static int DEFAULT_HEIGHT = 40;
    private static Color DEFAULT_COLOR = new Color(255, 228, 181);
    private static int FOLD_X = 8;
    private static int FOLD_Y = 8;

    public NoteNode() {
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
        this.text = new MultiLineString();
        this.text.setJustification(0);
        this.color = DEFAULT_COLOR;
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        PointNode end = new PointNode();
        end.translate(p2.getX(), p2.getY());
        e.connect(this, end);
        return super.checkAddEdge(e, p1, p2);
    }

    @Override
    public void checkRemoveEdge(Edge e) {
        if (e.getStart() == this) {
            this.getGraph().removeNodesAndEdges(Arrays.asList(e.getEnd()), null);
        }
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        for (Edge e : this.getGraph().getEdges()) {
            if (e.getStart() != this) continue;
            Node end = e.getEnd();
            Point2D endPoint = end.getLocation();
            Node n = this.getGraph().findNode(endPoint);
            if (n == end) continue;
            end.setZ(n.getZ() + 1);
        }
        Rectangle2D b = this.text.getBounds(g2);
        this.snapBounds(grid, Math.max(b.getWidth(), (double)DEFAULT_WIDTH), Math.max(b.getHeight(), (double)DEFAULT_HEIGHT));
    }

    public MultiLineString getText() {
        return this.text;
    }

    public void setText(MultiLineString newValue) {
        this.text = newValue;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newValue) {
        this.color = newValue;
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Color oldColor = g2.getColor();
        g2.setColor(this.color);
        Shape path = this.getShape();
        g2.fill(path);
        g2.setColor(oldColor);
        g2.draw(path);
        Rectangle2D bounds = this.getBounds();
        GeneralPath fold = new GeneralPath();
        fold.moveTo((float)(bounds.getMaxX() - (double)FOLD_X), (float)bounds.getY());
        fold.lineTo((float)bounds.getMaxX() - (float)FOLD_X, (float)bounds.getY() + (float)FOLD_X);
        fold.lineTo((float)bounds.getMaxX(), (float)(bounds.getY() + (double)FOLD_Y));
        fold.closePath();
        oldColor = g2.getColor();
        g2.setColor(g2.getBackground());
        g2.fill(fold);
        g2.setColor(oldColor);
        g2.draw(fold);
        this.text.draw(g2, this.getBounds());
    }

    @Override
    public Shape getShape() {
        Rectangle2D bounds = this.getBounds();
        GeneralPath path = new GeneralPath();
        path.moveTo((float)bounds.getX(), (float)bounds.getY());
        path.lineTo((float)(bounds.getMaxX() - (double)FOLD_X), (float)bounds.getY());
        path.lineTo((float)bounds.getMaxX(), (float)(bounds.getY() + (double)FOLD_Y));
        path.lineTo((float)bounds.getMaxX(), (float)bounds.getMaxY());
        path.lineTo((float)bounds.getX(), (float)bounds.getMaxY());
        path.closePath();
        return path;
    }

    @Override
    public NoteNode clone() {
        NoteNode cloned = (NoteNode)super.clone();
        cloned.text = this.text.clone();
        return cloned;
    }
}

