/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.object;

import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.ShapeEdge;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ObjectReferenceEdge
extends ShapeEdge {
    private static final int ENDSIZE = 10;

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getShape());
        Line2D line = this.getConnectionPoints();
        double x2 = line.getX2();
        double y = line.getY2();
        double x1 = this.isSShaped() ? x2 - 10.0 : x2 + 10.0;
        ArrowHead.BLACK_TRIANGLE.draw(g2, new Point2D.Double(x1, y), new Point2D.Double(x2, y));
    }

    @Override
    public Shape getShape() {
        Line2D line = this.getConnectionPoints();
        double y1 = line.getY1();
        double y2 = line.getY2();
        double xmid = (line.getX1() + line.getX2()) / 2.0;
        double ymid = (line.getY1() + line.getY2()) / 2.0;
        GeneralPath p = new GeneralPath();
        if (this.isSShaped()) {
            double x1 = line.getX1() + 10.0;
            double x2 = line.getX2() - 10.0;
            p.moveTo((float)line.getX1(), (float)y1);
            p.lineTo((float)x1, (float)y1);
            p.quadTo((float)((x1 + xmid) / 2.0), (float)y1, (float)xmid, (float)ymid);
            p.quadTo((float)((x2 + xmid) / 2.0), (float)y2, (float)x2, (float)y2);
            p.lineTo((float)line.getX2(), (float)y2);
        } else {
            double x1 = Math.max(line.getX1(), line.getX2()) + 10.0;
            double x2 = x1 + 10.0;
            p.moveTo((float)line.getX1(), (float)y1);
            p.lineTo((float)x1, (float)y1);
            p.quadTo((float)x2, (float)y1, (float)x2, (float)ymid);
            p.quadTo((float)x2, (float)y2, (float)x1, (float)y2);
            p.lineTo((float)line.getX2(), (float)y2);
        }
        return p;
    }

    @Override
    public Line2D getConnectionPoints() {
        Point2D p = this.getStart().getConnectionPoint(Direction.EAST);
        if (this.isSShaped()) {
            return new Line2D.Double(p, this.getEnd().getConnectionPoint(Direction.WEST));
        }
        return new Line2D.Double(p, this.getEnd().getConnectionPoint(Direction.EAST));
    }

    private boolean isSShaped() {
        Rectangle2D b = this.getEnd().getBounds();
        Point2D p = this.getStart().getConnectionPoint(Direction.EAST);
        return b.getX() >= p.getX() + 20.0;
    }
}

