/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.sequence;

import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.SegmentedLineEdge;
import com.horstmann.violet.product.diagram.common.PointNode;
import com.horstmann.violet.product.diagram.sequence.ActivationBarNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class CallEdge
extends SegmentedLineEdge {
    private boolean signal;

    public CallEdge() {
        this.setSignal(false);
    }

    public boolean isSignal() {
        return this.signal;
    }

    public void setSignal(boolean newValue) {
        this.signal = newValue;
        if (this.signal) {
            this.setEndArrowHead(ArrowHead.V);
        } else {
            this.setEndArrowHead(ArrowHead.BLACK_TRIANGLE);
        }
    }

    @Override
    public ArrayList<Point2D> getPoints() {
        ArrayList<Point2D> a = new ArrayList<Point2D>();
        Node n = this.getEnd();
        Rectangle2D start = this.getStart().getBounds();
        Rectangle2D end = n.getBounds();
        if (n instanceof ActivationBarNode && ((ActivationBarNode)n).getImplicitParameter() == ((ActivationBarNode)this.getStart()).getImplicitParameter()) {
            Point2D.Double p = new Point2D.Double(start.getMaxX(), end.getY() - (double)(ActivationBarNode.CALL_YGAP / 2));
            Point2D.Double q = new Point2D.Double(end.getMaxX(), end.getY());
            Point2D.Double s = new Point2D.Double(((Point2D)q).getX() + end.getWidth(), ((Point2D)q).getY());
            Point2D.Double r = new Point2D.Double(((Point2D)s).getX(), ((Point2D)p).getY());
            a.add(p);
            a.add(r);
            a.add(s);
            a.add(q);
        } else if (n instanceof PointNode) {
            a.add(new Point2D.Double(start.getMaxX(), start.getY()));
            a.add(new Point2D.Double(end.getX(), start.getY()));
        } else {
            Direction d = new Direction(start.getX() - end.getX(), 0.0);
            Point2D endPoint = this.getEnd().getConnectionPoint(d);
            if (start.getCenterX() < endPoint.getX()) {
                a.add(new Point2D.Double(start.getMaxX(), endPoint.getY()));
            } else {
                a.add(new Point2D.Double(start.getX(), endPoint.getY()));
            }
            a.add(endPoint);
        }
        return a;
    }
}

