/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.state;

import com.horstmann.violet.framework.diagram.ArrowHead;
import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.ShapeEdge;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class StateTransitionEdge
extends ShapeEdge {
    private double angle;
    private String labelText = "";
    private static JLabel label = new JLabel();

    public void setLabel(String newValue) {
        this.labelText = newValue;
    }

    public String getLabel() {
        return this.labelText;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getShape());
        this.drawLabel(g2);
        ArrowHead.V.draw(g2, this.getControlPoint(), this.getConnectionPoints().getP2());
    }

    private void drawLabel(Graphics2D g2) {
        Rectangle2D labelBounds = this.getLabelBounds(g2);
        double x = labelBounds.getX();
        double y = labelBounds.getY();
        g2.translate(x, y);
        label.paint(g2);
        g2.translate(-x, -y);
    }

    private Rectangle2D getLabelBounds(Graphics2D g2) {
        label.setText("<html>" + this.labelText + "</html>");
        label.setFont(g2.getFont());
        Dimension d = label.getPreferredSize();
        label.setBounds(0, 0, d.width, d.height);
        Line2D line = this.getConnectionPoints();
        Point2D control = this.getControlPoint();
        double x = control.getX() / 2.0 + line.getX1() / 4.0 + line.getX2() / 4.0;
        double y = control.getY() / 2.0 + line.getY1() / 4.0 + line.getY2() / 4.0;
        int GAP = 3;
        x = line.getY1() == line.getY2() ? (x -= d.getWidth() / 2.0) : (line.getY1() <= line.getY2() ? (x += 3.0) : (x -= d.getWidth() + 3.0));
        y = line.getX1() == line.getX2() ? (y += d.getHeight() / 2.0) : (line.getX1() <= line.getX2() ? (y -= d.getHeight() + 3.0) : (y += 3.0));
        if (Math.abs(line.getX1() - line.getX2()) >= Math.abs(line.getY1() - line.getY2())) {
            x -= d.getWidth() / 2.0;
        }
        if (Math.abs(line.getX1() - line.getX2()) <= Math.abs(line.getY1() - line.getY2())) {
            y -= d.getHeight() / 2.0;
        }
        return new Rectangle2D.Double(x, y, d.width, d.height);
    }

    private Point2D getControlPoint() {
        Line2D line = this.getConnectionPoints();
        double t = Math.tan(Math.toRadians(this.angle));
        double dx = (line.getX2() - line.getX1()) / 2.0;
        double dy = (line.getY2() - line.getY1()) / 2.0;
        return new Point2D.Double((line.getX1() + line.getX2()) / 2.0 + t * dy, (line.getY1() + line.getY2()) / 2.0 - t * dx);
    }

    @Override
    public Shape getShape() {
        Line2D line = this.getConnectionPoints();
        Point2D control = this.getControlPoint();
        GeneralPath p = new GeneralPath();
        p.moveTo((float)line.getX1(), (float)line.getY1());
        p.quadTo((float)control.getX(), (float)control.getY(), (float)line.getX2(), (float)line.getY2());
        return p;
    }

    @Override
    public Rectangle2D getBounds(Graphics2D g2) {
        Rectangle2D r = super.getBounds(g2);
        r.add(this.getLabelBounds(g2));
        return r;
    }

    @Override
    public Line2D getConnectionPoints() {
        Direction d2;
        Direction d1;
        if (this.getStart() == this.getEnd()) {
            this.angle = 60.0;
            d1 = Direction.EAST.turn(-30.0);
            d2 = Direction.EAST.turn(30.0);
        } else {
            this.angle = 10.0;
            Rectangle2D start = this.getStart().getBounds();
            Rectangle2D end = this.getEnd().getBounds();
            Point2D.Double startCenter = new Point2D.Double(start.getCenterX(), start.getCenterY());
            Point2D.Double endCenter = new Point2D.Double(end.getCenterX(), end.getCenterY());
            d1 = new Direction(startCenter, endCenter).turn(-5.0);
            d2 = new Direction(endCenter, startCenter).turn(5.0);
        }
        Point2D p = this.getStart().getConnectionPoint(d1);
        Point2D q = this.getEnd().getConnectionPoint(d2);
        return new Line2D.Double(p, q);
    }
}

