/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.usecase;

import com.horstmann.violet.framework.diagram.BentStyle;
import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.SegmentedLineEdge;
import com.horstmann.violet.product.diagram.usecase.ActorNode;
import com.horstmann.violet.product.diagram.usecase.UseCaseNode;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class UseCaseRelationshipEdge
extends SegmentedLineEdge {
    private BentStyle bentStyle = BentStyle.STRAIGHT;

    public void setBentStyle(BentStyle newValue) {
        this.bentStyle = newValue;
    }

    public BentStyle getBentStyle() {
        return this.bentStyle;
    }

    @Override
    public ArrayList<Point2D> getPoints() {
        Line2D connectionPoints = this.getConnectionPoints();
        Point2D p = connectionPoints.getP1();
        Point2D q = connectionPoints.getP2();
        Rectangle startingRect = new Rectangle(new Point((int)p.getX(), (int)p.getY()), new Dimension());
        Rectangle endingRect = new Rectangle(new Point((int)q.getX(), (int)q.getY()), new Dimension());
        return this.bentStyle.getPath(startingRect, endingRect);
    }

    @Override
    public Line2D getConnectionPoints() {
        Rectangle2D start = this.getStart().getBounds();
        Rectangle2D end = this.getEnd().getBounds();
        Point2D.Double startCenter = new Point2D.Double(start.getCenterX(), start.getCenterY());
        Point2D.Double endCenter = new Point2D.Double(end.getCenterX(), end.getCenterY());
        Direction d1 = new Direction(startCenter, endCenter);
        Direction d2 = new Direction(endCenter, startCenter);
        if (this.getStart() instanceof ActorNode && this.getEnd() instanceof UseCaseNode) {
            ArrayList<Point2D> points = this.bentStyle.getPath(this.getStart().getBounds(), this.getEnd().getBounds());
            Point2D p = this.getStart().getConnectionPoint(d1);
            Point2D q = points.get(points.size() - 1);
            return new Line2D.Double(p, q);
        }
        if (this.getStart() instanceof ActorNode && this.getEnd() instanceof ActorNode) {
            ArrayList<Point2D> points = this.bentStyle.getPath(this.getStart().getBounds(), this.getEnd().getBounds());
            Point2D p = points.get(0);
            Point2D q = this.getEnd().getConnectionPoint(d2);
            return new Line2D.Double(p, q);
        }
        Point2D p = this.getStart().getConnectionPoint(d1);
        Point2D q = this.getEnd().getConnectionPoint(d2);
        return new Line2D.Double(p, q);
    }
}

