/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class PgsTabbedPaneUI
extends BasicTabbedPaneUI {
    private boolean paintFocus;
    private int rolloverTabIndex;
    private TabRolloverHandler tabHandler;
    private MyPropertyChangeHandler propHandler;
    private TabbedPaneMouseWheelScroller tabScrollHandler;
    private TabSelectionMouseHandler tabSelectionHandler;
    private static Logger logger = Logger.getLogger("PgsTabbedPaneUI");
    public static final String IS_SUB_TAB = "pgs.isSubTab";
    public static final String IS_BUTTON_STYLE = "pgs.isButtonStyle";
    public static final String NO_BORDER = "pgs.noBorder";
    private TabReorderHandler tabReorderingHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateBackgroundOpacity();
        this.paintFocus = UIManager.getBoolean("TabbedPane.focusPainted");
    }

    protected void installListeners() {
        super.installListeners();
        if (this.tabHandler == null) {
            this.tabHandler = new TabRolloverHandler();
        }
        this.tabPane.addMouseListener(this.tabHandler);
        this.tabPane.addMouseMotionListener(this.tabHandler);
        if (this.propHandler == null) {
            this.propHandler = new MyPropertyChangeHandler();
        }
        this.tabPane.addPropertyChangeListener(this.propHandler);
        if (PlafOptions.isWheelTabbedPaneEnabled()) {
            if (this.tabScrollHandler == null) {
                this.tabScrollHandler = new TabbedPaneMouseWheelScroller();
            }
            this.tabPane.addMouseWheelListener(this.tabScrollHandler);
        }
        if (PlafOptions.isTabbedPaneRightClickSelectionEnabled()) {
            if (this.tabSelectionHandler == null) {
                this.tabSelectionHandler = new TabSelectionMouseHandler();
            }
            this.tabPane.addMouseListener(this.tabSelectionHandler);
        }
        if (PlafOptions.isTabReorderingEnabled()) {
            this.enableReordering();
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseListener(this.tabHandler);
        this.tabPane.removeMouseMotionListener(this.tabHandler);
        this.tabPane.removePropertyChangeListener(this.propHandler);
        if (this.tabScrollHandler != null) {
            this.tabPane.removeMouseWheelListener(this.tabScrollHandler);
        }
        if (this.tabSelectionHandler != null) {
            this.tabPane.removeMouseListener(this.tabSelectionHandler);
        }
        this.disableReordering();
    }

    private void updateBackgroundOpacity() {
        if (this.isSubTab() || this.isButtonStyle()) {
            this.tabPane.setOpaque(true);
            if (this.isSubTab()) {
                this.tabPane.setBackground(UIManager.getColor("TabbedPane.background"));
            } else if (this.isButtonStyle()) {
                this.tabPane.setBackground(UIManager.getColor("TabbedPane.buttonStyle.background"));
            }
        } else {
            this.tabPane.setOpaque(false);
        }
    }

    private boolean checkBooleanClientProperty(Object object) {
        Object object2 = this.tabPane.getClientProperty(object);
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        if (object2 instanceof Integer) {
            return (Integer)object2 != 0;
        }
        logger.warning("It seems like you've used a wrong type for '" + object + "'. It should be a boolean, but is a " + object2.getClass().getName());
        return true;
    }

    private boolean isSubTab() {
        return this.checkBooleanClientProperty(IS_SUB_TAB);
    }

    private boolean isButtonStyle() {
        return this.checkBooleanClientProperty(IS_BUTTON_STYLE);
    }

    private void mySetRolloverTab(int n, int n2) {
        this.mySetRolloverTab(this.myTabForCoordinate(this.tabPane, n, n2));
    }

    private int myTabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        Point point = new Point(n, n2);
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(point.x, point.y)) continue;
            return i;
        }
        return -1;
    }

    protected void mySetRolloverTab(int n) {
        this.tabPane.repaint();
        this.rolloverTabIndex = n;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Object object2;
        if (this.isButtonStyle()) {
            if (bl) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.selectedBackground"));
                graphics.fillRect(n3 + 2, n4 + 2, n5 - 4, n6 - 4);
            }
            if (n2 == this.getRolloverTab() && this.tabPane.isEnabledAt(n2)) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.rolloverBackground"));
                if (bl) {
                    graphics.fillRect(n3 + 2, n4 + 2, n5 - 4, n6 - 4);
                } else {
                    graphics.fillRect(n3, n4, n5, n6);
                }
            }
            return;
        }
        if (this.isSubTab() && !bl) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.setColor(UIManager.getColor("TabbedPane.selected"));
        } else {
            object2 = UIManager.getColor("TabbedPane.tabGradientStart");
            object = UIManager.getColor("TabbedPane.tabGradientEnd");
            graphics2D.setPaint(new GradientPaint(0.0f, n4 + 1, (Color)object2, 0.0f, n4 + 1 + n6, (Color)object));
        }
        switch (n) {
            case 2: {
                graphics2D.fill(new Rectangle(n3, n4, n5 + 2, n6));
                break;
            }
            case 4: {
                graphics2D.fill(new Rectangle(n3 - 2, n4, n5 + 2, n6));
                break;
            }
            case 3: {
                graphics2D.fill(new Rectangle(n3, n4 - 2, n5, n6 + 2));
                break;
            }
            default: {
                graphics2D.fill(new Rectangle(n3, n4, n5 - 2, n6 + 2));
            }
        }
        if (!bl && n2 == this.getRolloverTab() && this.tabPane.isEnabledAt(n2)) {
            object2 = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(PgsLookAndFeel.getGlow());
            object = graphics2D.getStroke();
            graphics2D.setStroke(PgsUtils.rolloverBorderStroke);
            switch (n) {
                case 2: {
                    graphics2D.drawRoundRect(n3 + 1, n4 + 1, n5 + 1, n6 - 3, 5, 5);
                    break;
                }
                case 4: {
                    graphics2D.drawRoundRect(n3 - 2, n4 + 1, n5 + 1, n6 - 2, 5, 5);
                    break;
                }
                case 3: {
                    graphics2D.drawRoundRect(n3 + 1, n4 - 2, n5 - 3, n6, 5, 5);
                    break;
                }
                default: {
                    graphics2D.drawRoundRect(n3 + 1, n4 + 1, n5 - 4, n6 + 1, 5, 5);
                }
            }
            graphics2D.setStroke((Stroke)object);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ((RenderingHints)object2).get(RenderingHints.KEY_ANTIALIASING));
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.isButtonStyle()) {
            if (bl) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.selectedBorder"));
                graphics.drawRect(n3 + 2, n4 + 2, n5 - 4, n6 - 4);
            }
            if (n2 == this.getRolloverTab()) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.rolloverBorder"));
                if (bl) {
                    graphics.drawRect(n3 + 2, n4 + 2, n5 - 4, n6 - 4);
                } else {
                    graphics.drawRect(n3, n4, n5, n6);
                }
            }
            return;
        }
        if (this.isSubTab() && !bl) {
            graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(PgsLookAndFeel.getControlDarkShadow());
        if (this.isSubTab()) {
            switch (n) {
                case 2: {
                    graphics2D.drawRect(n3, n4, n5 + 2, n6);
                    break;
                }
                case 4: {
                    graphics2D.drawRect(n3 - 2, n4, n5 + 2, n6);
                    break;
                }
                case 3: {
                    graphics2D.drawRect(n3, n4 - 2, n5, n6 + 2);
                    break;
                }
                default: {
                    graphics2D.drawRect(n3, n4, n5 - 2, n6 + 2);
                    break;
                }
            }
        } else {
            switch (n) {
                case 2: {
                    graphics2D.drawRoundRect(n3, n4, n5 + 2, n6, 5, 5);
                    break;
                }
                case 4: {
                    graphics2D.drawRoundRect(n3 - 2, n4, n5 + 2, n6, 5, 5);
                    break;
                }
                case 3: {
                    graphics2D.drawRoundRect(n3, n4 - 2, n5, n6 + 2, 5, 5);
                    break;
                }
                default: {
                    graphics2D.drawRoundRect(n3, n4, n5 - 2, n6 + 2, 5, 5);
                }
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.paintFocus) {
            super.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n);
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        boolean bl = true;
        int n9 = 0;
        int n10 = 0;
        switch (n) {
            case 2: {
                n9 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n5 += n9;
                if (bl) {
                    n5 -= insets2.right;
                }
                n7 -= n5 - insets.left;
                break;
            }
            case 4: {
                n9 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                n7 -= n9;
                if (!bl) break;
                n7 += insets2.left;
                break;
            }
            case 3: {
                n10 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n8 -= n10;
                if (!bl) break;
                n8 += insets2.top;
                break;
            }
            default: {
                n10 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                n6 += n10;
                if (bl) {
                    n6 -= insets2.bottom;
                }
                n8 -= n6 - insets.top;
            }
        }
        Color color = UIManager.getColor("TabbedPane.contentAreaColor");
        Color color2 = UIManager.getColor("TabbedPane.selected");
        if (color != null) {
            graphics.setColor(color);
        } else if (color2 == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(color2);
        }
        graphics.fillRect(n5, n6, n7, n8);
        if (this.checkBooleanClientProperty(NO_BORDER)) {
            return;
        }
        graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
        PgsUtils.drawRoundRect(graphics, n5, n6, n7 - 1, n8 - 1);
        if (n2 > -1 && !this.isButtonStyle()) {
            Rectangle rectangle = this.getTabBounds(n2, this.calcRect);
            graphics.setColor(UIManager.getColor("TabbedPane.selected"));
            switch (n) {
                case 1: {
                    graphics.fillRect(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.width - 2, 1);
                    if (n2 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(n5, rectangle.y + rectangle.height - 2, n5, rectangle.y + rectangle.height + 2);
                    break;
                }
                case 3: {
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, 1);
                    if (n2 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(n5, rectangle.y - 2, n5, rectangle.y + 2);
                    break;
                }
                case 2: {
                    graphics.fillRect(rectangle.x + rectangle.width - 2, rectangle.y + 1, 1, rectangle.height - 1);
                    if (n2 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y, rectangle.x + rectangle.width + 2, rectangle.y);
                    break;
                }
                case 4: {
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, 1, rectangle.height - 1);
                    if (n2 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(rectangle.x - 2, rectangle.y, rectangle.x + 2, rectangle.y);
                }
            }
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        PgsUtils.installAntialiasing(graphics);
        super.paintText(graphics, n, font, fontMetrics, n2, string, rectangle, bl);
        PgsUtils.uninstallAntialiasing(graphics);
    }

    protected JButton createScrollButton(int n) {
        if (n != 5 && n != 1 && n != 3 && n != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(n);
    }

    public void enableReordering() {
        if (this.tabReorderingHandler == null) {
            this.tabReorderingHandler = new TabReorderHandler();
        }
        this.tabPane.addMouseListener(this.tabReorderingHandler);
        this.tabPane.addMouseMotionListener(this.tabReorderingHandler);
    }

    public void disableReordering() {
        this.tabPane.removeMouseListener(this.tabReorderingHandler);
        this.tabPane.removeMouseMotionListener(this.tabReorderingHandler);
    }

    public class TabbedPaneMouseWheelScroller
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseWheelEvent.getSource();
            int n = mouseWheelEvent.getWheelRotation();
            int n2 = jTabbedPane.getSelectedIndex();
            int n3 = jTabbedPane.getTabCount() - 1;
            n2 = n2 == 0 && n < 0 || n2 == n3 && n > 0 ? n3 - n2 : (n2 += n);
            jTabbedPane.setSelectedIndex(n2);
        }
    }

    public class SelectTabAction
    extends AbstractAction {
        private JTabbedPane tabPane;
        private int index;

        public SelectTabAction(JTabbedPane jTabbedPane, int n) {
            super(jTabbedPane.getTitleAt(n), jTabbedPane.getIconAt(n));
            this.tabPane = jTabbedPane;
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tabPane.setSelectedIndex(this.index);
        }
    }

    public class TabSelectionMouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n = jTabbedPane.getTabCount();
                for (int i = 0; i < n; ++i) {
                    jPopupMenu.add(new SelectTabAction(jTabbedPane, i));
                }
                jPopupMenu.show(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class TabReorderHandler
    extends MouseInputAdapter {
        private int draggedTabIndex = -1;

        protected TabReorderHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.draggedTabIndex = -1;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.draggedTabIndex == -1) {
                return;
            }
            int n = PgsTabbedPaneUI.this.tabPane.getUI().tabForCoordinate(PgsTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && n != this.draggedTabIndex) {
                boolean bl = n > this.draggedTabIndex;
                PgsTabbedPaneUI.this.tabPane.insertTab(PgsTabbedPaneUI.this.tabPane.getTitleAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getIconAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getComponentAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getToolTipTextAt(this.draggedTabIndex), bl ? n + 1 : n);
                this.draggedTabIndex = n;
                PgsTabbedPaneUI.this.tabPane.setSelectedIndex(this.draggedTabIndex);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.draggedTabIndex = PgsTabbedPaneUI.this.tabPane.getUI().tabForCoordinate(PgsTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n) {
            super(n, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
            this.setOpaque(false);
        }

        public void paint(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            Color color = graphics.getColor();
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.isEnabled();
            if (bl2 && this.getModel().isRollover()) {
                graphics.setColor(bl ? PgsLookAndFeel.getPrimaryControlShadow() : UIManager.getColor("ToolBarButton.rolloverBackground"));
                graphics.fillRect(0, 0, n - 2, n2 - 2);
                graphics.setColor(UIManager.getColor("ToolBarButton.rolloverBorderColor"));
                graphics.drawRect(0, 0, n - 2, n2 - 2);
            }
            if (n2 < 5 || n < 5) {
                graphics.setColor(color);
                return;
            }
            if (bl) {
                graphics.translate(1, 1);
            }
            int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
            n3 = Math.max(n3, 2);
            this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, bl2);
            if (bl) {
                graphics.translate(-1, -1);
            }
            graphics.setColor(color);
        }
    }

    public class MyPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PgsTabbedPaneUI.IS_SUB_TAB.equals(propertyChangeEvent.getPropertyName()) || PgsTabbedPaneUI.IS_BUTTON_STYLE.equals(propertyChangeEvent.getPropertyName())) {
                PgsTabbedPaneUI.this.updateBackgroundOpacity();
            } else if ("wheelScrolling".equals(propertyChangeEvent.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("wheelScrolling")) {
                    if (PgsTabbedPaneUI.this.tabScrollHandler == null) {
                        PgsTabbedPaneUI.this.tabScrollHandler = new TabbedPaneMouseWheelScroller();
                    }
                    PgsTabbedPaneUI.this.tabPane.addMouseWheelListener(PgsTabbedPaneUI.this.tabScrollHandler);
                } else if (PgsTabbedPaneUI.this.tabScrollHandler != null) {
                    PgsTabbedPaneUI.this.tabPane.removeMouseWheelListener(PgsTabbedPaneUI.this.tabScrollHandler);
                }
            } else if ("rightClickSelection".equals(propertyChangeEvent.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("rightClickSelection")) {
                    if (PgsTabbedPaneUI.this.tabSelectionHandler == null) {
                        PgsTabbedPaneUI.this.tabSelectionHandler = new TabSelectionMouseHandler();
                    }
                    PgsTabbedPaneUI.this.tabPane.addMouseListener(PgsTabbedPaneUI.this.tabSelectionHandler);
                } else if (PgsTabbedPaneUI.this.tabSelectionHandler != null) {
                    PgsTabbedPaneUI.this.tabPane.removeMouseListener(PgsTabbedPaneUI.this.tabSelectionHandler);
                }
            } else if ("tabReordering".equals(propertyChangeEvent.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("tabReordering")) {
                    PgsTabbedPaneUI.this.enableReordering();
                } else {
                    PgsTabbedPaneUI.this.disableReordering();
                }
            }
        }
    }

    protected class TabRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        protected TabRolloverHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            PgsTabbedPaneUI.this.mySetRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PgsTabbedPaneUI.this.mySetRolloverTab(-1);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PgsTabbedPaneUI.this.mySetRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

