/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

public class Util {
    public static void checkJavaIdentifier(String pName) {
        if (pName.length() == 0) {
            throw new IllegalArgumentException("A valid Java identifier must not be empty.");
        }
        char c = pName.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            throw new IllegalArgumentException("The identifier " + pName + " is no valid Java identifier, because its first character is " + c);
        }
        for (int i = 1; i < pName.length(); ++i) {
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException("The identifier " + pName + " is no valid Java identifier, because it contains the character " + c);
        }
    }

    public static String asJavaIdentifier(String pIdentifier) {
        if (pIdentifier == null || pIdentifier.length() == 0) {
            throw new IllegalArgumentException("A null or empty String cannot be converted into a valid Java identifier.");
        }
        StringBuffer sb = new StringBuffer();
        char c = pIdentifier.charAt(0);
        sb.append(Character.isJavaIdentifierStart(c) ? c : (char)'_');
        for (int i = 1; i < pIdentifier.length(); ++i) {
            c = pIdentifier.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return sb.toString();
    }
}

