/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.net.URL;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.pattern.CompiledClassReflector;
import org.apache.ws.jaxme.js.pattern.SourceReflector;

public class InterfaceDescription {
    private boolean isMandatory = true;
    private String interfaceName;
    private String type;
    private JavaSource javaSource;

    private ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader(), ClassLoader.getSystemClassLoader()};
    }

    public void setInterface(String pName) {
        this.interfaceName = pName;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setType(String pType) {
        if (pType != null && !"Reflection".equalsIgnoreCase(pType) && !"Source".equalsIgnoreCase(pType)) {
            throw new IllegalArgumentException("Invalid type: " + pType + ", expected 'Reflection', 'Source', or null.");
        }
        this.type = pType;
    }

    public String getType() {
        return this.type;
    }

    public void setMandatory(boolean pMandatory) {
        this.isMandatory = pMandatory;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public JavaSource getJavaSource() throws Exception {
        if (this.javaSource == null) {
            this.javaSource = this.initJavaSource();
        }
        return this.javaSource;
    }

    private JavaSource initJavaSource() throws Exception {
        int i;
        ClassLoader[] cls;
        String mode;
        Exception ex;
        block7: {
            ex = null;
            mode = this.getType();
            if (mode == null || "Reflection".equals(mode)) {
                try {
                    cls = this.getClassLoaders();
                    for (i = 0; i < cls.length; ++i) {
                        Class<?> c;
                        if (cls[i] == null || (c = cls[i].loadClass(this.getInterface())) == null) continue;
                        return new CompiledClassReflector(c).getJavaSource(new JavaSourceFactory());
                    }
                }
                catch (Exception e) {
                    if (ex != null) break block7;
                    ex = e;
                }
            }
        }
        if (mode == null || "Source".equals(mode)) {
            cls = this.getClassLoaders();
            for (i = 0; i < cls.length; ++i) {
                URL url;
                if (cls[i] == null || (url = cls[i].getResource(this.getInterface().replace('.', '/') + ".java")) == null) continue;
                SourceReflector reflector = new SourceReflector(url);
                return reflector.getJavaSource(new JavaSourceFactory());
            }
        }
        if (ex == null) {
            throw new IllegalStateException("Failed to locate Java class " + this.getInterface());
        }
        throw ex;
    }
}

