/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js.pattern;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.ws.jaxme.js.JavaComment;
import org.apache.ws.jaxme.js.JavaConstructor;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.Util;

public class TypesafeEnumerationGenerator {
    private boolean isAddingEquals = true;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$lang$Object;

    public void setAddingEquals(boolean pAddingEquals) {
        this.isAddingEquals = pAddingEquals;
    }

    public boolean isAddingEquals() {
        return this.isAddingEquals;
    }

    public JavaSource generate(JavaSourceFactory pFactory, JavaQName pTargetClass, Item[] pItems) {
        JavaSource result = pFactory.newJavaSource(pTargetClass, JavaSource.PUBLIC);
        this.doGenerate(result, pItems);
        return result;
    }

    public JavaInnerClass generate(JavaSource pSource, String pName, Item[] pItems) {
        JavaInnerClass result = pSource.newJavaInnerClass(pName, JavaSource.PUBLIC);
        result.setStatic(true);
        this.doGenerate(result, pItems);
        return result;
    }

    private void doGenerate(JavaSource pSource, Item[] pItems) {
        HashSet<String> names = new HashSet<String>();
        HashSet values = new HashSet();
        for (int i = 0; i < pItems.length; ++i) {
            String itemName = pItems[i].getName();
            String itemValue = pItems[i].getValue();
            if (itemName == null) {
                itemName = Util.asJavaIdentifier(itemValue.toUpperCase());
                pItems[i].setName(itemName);
            }
            if (names.contains(itemName)) {
                throw new IllegalStateException("The item name " + itemName + " is not unique.");
            }
            if (values.contains(itemValue)) {
                throw new IllegalStateException("The item value " + itemValue + " is not unique.");
            }
            names.add(itemName);
            names.add(itemValue);
        }
        pSource.addImplements(class$java$io$Serializable == null ? (class$java$io$Serializable = TypesafeEnumerationGenerator.class$("java.io.Serializable")) : class$java$io$Serializable);
        JavaField name = pSource.newJavaField("name", class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PRIVATE);
        name.setFinal(true);
        JavaField value = pSource.newJavaField("value", class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PRIVATE);
        name.setFinal(true);
        JavaConstructor jcon = pSource.newJavaConstructor(JavaSource.PRIVATE);
        jcon.addParam(class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, "pName");
        jcon.addParam(class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, "pValue");
        jcon.addLine("name = pName;");
        jcon.addLine("value = pValue;");
        ArrayList<Object> instanceList = new ArrayList<Object>();
        for (int i = 0; i < pItems.length; ++i) {
            Item item = pItems[i];
            String itemName = item.getName();
            String itemValue = item.getValue();
            JavaField instance = pSource.newJavaField(itemName, pSource.getQName(), JavaSource.PUBLIC);
            instance.newComment().addLine("The enumeration item with name " + itemName + " and value " + itemValue + ".");
            instance.setStatic(true);
            instance.setFinal(true);
            instance.addLine("new ", pSource.getQName(), "(", JavaSource.getQuoted(itemName), ", ", JavaSource.getQuoted(itemValue), ")");
            if (i > 0) {
                instanceList.add(", ");
            }
            instanceList.add(instance);
        }
        JavaQName arrayType = JavaQNameImpl.getArray(pSource.getQName());
        JavaField allInstances = pSource.newJavaField("allInstances", arrayType, JavaSource.PRIVATE);
        allInstances.setStatic(true);
        allInstances.setFinal(true);
        allInstances.addLine("new ", arrayType, "{", instanceList, "}");
        JavaMethod getName = pSource.newJavaMethod("getName", class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PUBLIC);
        getName.newComment().addLine("The enumeration items name.");
        getName.addLine("return ", name, ";");
        JavaMethod getValue = pSource.newJavaMethod("getValue", class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, JavaSource.PUBLIC);
        getValue.newComment().addLine("The enumeration items value.");
        getValue.addLine("return ", value, ";");
        JavaMethod getInstances = pSource.newJavaMethod("getInstances", arrayType, JavaSource.PUBLIC);
        getInstances.setStatic(true);
        getInstances.addLine("return ", allInstances, ";");
        JavaMethod getInstanceByName = pSource.newJavaMethod("getInstanceByName", pSource.getQName(), JavaSource.PUBLIC);
        getInstanceByName.setStatic(true);
        getInstanceByName.addParam(class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, "pName");
        JavaComment jc = getInstanceByName.newComment();
        jc.addLine("Returns the item with the given name.</p>");
        jc.addThrows((class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = TypesafeEnumerationGenerator.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException).getName() + " The name <code>pName</code> is invalid and no such item exists.");
        getInstanceByName.addLine(class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, " s = pName.intern();");
        boolean first = true;
        for (int i = 0; i < pItems.length; ++i) {
            Item item = pItems[i];
            Object[] args = new Object[]{JavaSource.getQuoted(item.getName()), " == s"};
            getInstanceByName.addIf(first, args);
            getInstanceByName.addLine("return ", item.getName(), ";");
            first = false;
        }
        getInstanceByName.addElse();
        getInstanceByName.addLine("throw new ", class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = TypesafeEnumerationGenerator.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, "(", JavaSource.getQuoted("Invalid name: "), " + pName);");
        getInstanceByName.addEndIf();
        JavaMethod getInstanceByValue = pSource.newJavaMethod("getInstanceByValue", pSource.getQName(), JavaSource.PUBLIC);
        getInstanceByValue.setStatic(true);
        getInstanceByValue.addParam(class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, "pValue");
        jc = getInstanceByValue.newComment();
        jc.addLine("Returns the item with the given value.</p>");
        jc.addThrows((class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = TypesafeEnumerationGenerator.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException).getName() + " The name <code>pValue</code> is invalid and no such item exists.");
        getInstanceByValue.addLine(class$java$lang$String == null ? (class$java$lang$String = TypesafeEnumerationGenerator.class$("java.lang.String")) : class$java$lang$String, " s = pValue.intern();");
        first = true;
        for (int i = 0; i < pItems.length; ++i) {
            Item item = pItems[i];
            Object[] args = new Object[]{JavaSource.getQuoted(item.getValue()), " == s"};
            getInstanceByValue.addIf(first, args);
            getInstanceByValue.addLine("return ", item.getName(), ";");
            first = false;
        }
        getInstanceByValue.addElse();
        getInstanceByValue.addLine("throw new ", class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = TypesafeEnumerationGenerator.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, "(", JavaSource.getQuoted("Invalid name: "), " + pValue);");
        getInstanceByValue.addEndIf();
        if (this.isAddingEquals()) {
            JavaMethod equals = pSource.newJavaMethod("equals", JavaQNameImpl.BOOLEAN, JavaSource.PUBLIC);
            equals.addParam(class$java$lang$Object == null ? (class$java$lang$Object = TypesafeEnumerationGenerator.class$("java.lang.Object")) : class$java$lang$Object, "o");
            equals.addIf("o == null  ||  !(o instanceof ", (Object)pSource.getQName(), (Object)")");
            equals.addLine("return false;");
            equals.addEndIf();
            equals.addLine("return name.equals(((", pSource.getQName(), ") o).name);");
            JavaMethod hashCode = pSource.newJavaMethod("hashCode", JavaQNameImpl.INT, JavaSource.PUBLIC);
            hashCode.addLine("return name.hashCode();");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Item {
        private String name;
        private String value;

        public void setName(String pName) {
            if (pName != null) {
                Util.checkJavaIdentifier(pName);
            }
            this.name = pName;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String pValue) {
            this.value = pValue;
        }

        public String getValue() {
            return this.value;
        }

        public void finish() {
            if (this.getValue() == null) {
                throw new IllegalStateException("The enumeration items 'value' attribute is not set.");
            }
            if (this.getName() == null) {
                try {
                    Util.asJavaIdentifier(this.getValue().toUpperCase());
                }
                catch (Exception e) {
                    throw new IllegalStateException("The enumeration items 'name' attribute is not set  and the value " + this.getValue() + " cannot be converted into a valid Java identifier.");
                }
            }
        }
    }
}

