/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet;

import com.horstmann.violet.framework.action.FileAction;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.file.FileService;
import com.horstmann.violet.framework.gui.Clipboard;
import com.horstmann.violet.framework.gui.EditorFrame;
import com.horstmann.violet.framework.gui.SplashScreen;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.preference.PreferencesServiceFactory;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.framework.util.VersionChecker;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import javax.swing.JApplet;

public class UMLEditor
extends JApplet {
    private static final String JAVA_VERSION = "1.6";
    private static final int APPLET_STARTING_MODE = 1;
    private static final int WEBSTART_STARTING_MODE = 2;
    private static final int CMDLINE_STARTING_MODE = 3;
    public static final int EXIT_SOFTWARE = 0;
    public static final int RESTART_WORKSPACE = 222;
    private int startingMode = 0;
    private String[] args;
    private EditorFrame editorFrame;
    private static UMLEditor instance;
    private ClassLoader pluginClassLoader;
    private Clipboard clipboard = new Clipboard();

    public UMLEditor() throws HeadlessException {
        UMLEditor.setInstance(this);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-reset".equals(arg)) {
                PreferencesServiceFactory.getInstance().reset();
                System.out.println("User preferences reset done.");
            }
            if ("-english".equals(arg)) {
                Locale.setDefault(Locale.ENGLISH);
                System.out.println("Language forced to english.");
            }
            if (!"-help".equals(arg) && !"-?".equals(arg)) continue;
            System.out.println("Violet UML Editor command line help. Options are :");
            System.out.println("-reset to reset user preferences,");
            System.out.println("-english to force language to english.");
            return;
        }
        UMLEditor editor = new UMLEditor();
        editor.startingMode = 3;
        String startedWithWebStart = System.getProperty("startedWithWebStart", "false");
        if ("true".equals(startedWithWebStart)) {
            editor.startingMode = 2;
        }
        editor.createWorkspace();
    }

    @Override
    public void init() {
        this.startingMode = 1;
        this.createWorkspace();
    }

    private void createWorkspace() {
        try {
            switch (this.startingMode) {
                case 1: {
                    ThemeManager.getInstance().applyPreferedTheme();
                    this.editorFrame = new EditorFrame();
                    this.editorFrame.setExtendedState(6);
                    this.setContentPane(this.editorFrame.getContentPane());
                    this.setJMenuBar(this.editorFrame.getJMenuBar());
                    String url = this.getParameter("diagram");
                    if (url != null) {
                        try {
                            FileAction fileAction = new FileAction();
                            fileAction.openURL(new URL(this.getDocumentBase(), url), this.editorFrame);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.editorFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            System.out.println("editor closed");
                        }
                    });
                    break;
                }
                case 2: {
                    ThemeManager.getInstance().applyPreferedTheme();
                    this.editorFrame = new EditorFrame();
                    this.editorFrame.setExtendedState(6);
                    this.editorFrame.setVisible(true);
                    break;
                }
                case 3: {
                    ThemeManager.getInstance().applyPreferedTheme();
                    SplashScreen splashScreen = new SplashScreen();
                    VersionChecker checker = new VersionChecker();
                    checker.check(JAVA_VERSION);
                    this.editorFrame = new EditorFrame();
                    this.editorFrame.setExtendedState(6);
                    FileAction fileAction = new FileAction();
                    SplashScreen.displayOverEditor(this.editorFrame, 1000);
                    if (this.args != null && this.args.length != 0) {
                        for (int i = 0; i < this.args.length; ++i) {
                            fileAction.open(this.args[i], this.editorFrame);
                        }
                    }
                    String[] filePaths = FileService.getOpenedFilesDuringLastSession();
                    fileAction.open(filePaths, this.editorFrame);
                    String activeDiagramFile = FileService.getActiveDiagramFile();
                    this.editorFrame.setActiveDiagramPanel(activeDiagramFile);
                    this.editorFrame.setVisible(true);
                    splashScreen.setVisible(false);
                    splashScreen.dispose();
                    this.installGraphPlugins();
                    break;
                }
                default: {
                    System.err.println("Could not establish if software has been launched as an applet, via webstart or with command line. Stopping...");
                    System.exit(-1);
                    break;
                }
            }
        }
        catch (ExceptionInInitializerError e) {
            System.out.println("Error while initializing workspace. User preferences has been reset for safety reasons.");
            PreferencesServiceFactory.getInstance().reset();
            throw e;
        }
    }

    public void installGraphPlugins() {
        ClassLoader pcl = this.getPluginClassLoader();
        if (pcl == null) {
            return;
        }
        ServiceLoader<Graph> graphServices = ServiceLoader.load(Graph.class, pcl);
        for (Graph graph : graphServices) {
            ResourceBundle bundle = ResourceBundle.getBundle(graph.getClass().getName() + "Strings", Locale.getDefault(), this.pluginClassLoader);
            ResourceFactory factory = new ResourceFactory(bundle);
            this.editorFrame.getMenuFactory().getFileMenu(this.editorFrame).createGraphTypeMenuItem("file.new", graph.getClass(), factory, this.editorFrame);
        }
    }

    public void exit() {
        System.exit(0);
    }

    public void exitWithErrors() {
        PreferencesServiceFactory.getInstance().reset();
        System.exit(-1);
    }

    public void restart() {
        this.editorFrame.dispose();
        ThemeManager.getInstance().applyPreferedTheme();
        this.createWorkspace();
    }

    public ClassLoader getPluginClassLoader() {
        if (this.pluginClassLoader == null) {
            String pluginDirName = System.getProperty("violet.plugin.dir");
            if (pluginDirName == null) {
                return null;
            }
            File pluginDir = new File(pluginDirName);
            File[] pluginJars = pluginDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.toString().endsWith(".jar");
                }
            });
            URL[] pluginJarUrls = new URL[pluginJars.length];
            for (int i = 0; i < pluginJars.length; ++i) {
                try {
                    pluginJarUrls[i] = pluginJars[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
            this.pluginClassLoader = new URLClassLoader(pluginJarUrls);
        }
        return this.pluginClassLoader;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    private static void setInstance(UMLEditor instance) {
        UMLEditor.instance = instance;
    }

    public static UMLEditor getInstance() {
        if (instance == null) {
            UMLEditor.setInstance(new UMLEditor());
        }
        return instance;
    }
}

