/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.action;

import com.horstmann.violet.framework.gui.AboutDialog;
import com.horstmann.violet.framework.gui.DialogFactory;
import com.horstmann.violet.framework.util.BrowserLauncher;
import com.horstmann.violet.framework.util.ClipboardPipe;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class HelpAction {
    ResourceBundle rs = ResourceBundle.getBundle("properties.MenuStrings", Locale.getDefault());

    public void showAboutDialog(JFrame parentFrame) {
        AboutDialog dialog = new AboutDialog(parentFrame);
        dialog.setVisible(true);
    }

    public void openUserGuide() {
        String url = this.rs.getString("help.userguide.url");
        boolean isOK = BrowserLauncher.openURL(url);
        if (!isOK) {
            this.openBrowser(url);
        }
    }

    public void openHomepage() {
        String url = this.rs.getString("help.homepage.url");
        boolean isOK = BrowserLauncher.openURL(url);
        if (!isOK) {
            this.openBrowser(url);
        }
    }

    private void openBrowser(String url) {
        String message = MessageFormat.format(this.rs.getString("dialog.open_url_failed.ok"), url);
        String title = this.rs.getString("dialog.open_url_failed.title");
        ImageIcon icon = new ImageIcon(this.getClass().getResource(this.rs.getString("dialog.open_url_failed.icon")));
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(message);
        optionPane.setIcon(icon);
        ClipboardPipe pipe = new ClipboardPipe(url);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(pipe, null);
        DialogFactory.getInstance().showDialog(optionPane, title, true);
    }
}

