/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.AbstractNode;
import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Grid;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class RectangularNode
extends AbstractNode {
    private transient Rectangle2D.Double bounds = new Rectangle2D.Double();

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this.bounds.setFrame(this.bounds.getX() + dx, this.bounds.getY() + dy, this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public boolean contains(Point2D p) {
        return this.bounds.contains(p);
    }

    @Override
    public Rectangle2D getBounds() {
        return (Rectangle2D)this.bounds.clone();
    }

    public void snapBounds(Grid g, double width, double height) {
        this.bounds.setFrame(this.getLocation().getX(), this.getLocation().getY(), width, height);
        g.snap(this.bounds);
    }

    public void setBounds(Rectangle2D newBounds) {
        this.bounds.setFrame(newBounds);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        this.snapBounds(grid, this.bounds.getWidth(), this.bounds.getHeight());
    }

    @Override
    public Point2D getConnectionPoint(Direction d) {
        double slope = this.bounds.getHeight() / this.bounds.getWidth();
        double ex = d.getX();
        double ey = d.getY();
        double x = this.bounds.getCenterX();
        double y = this.bounds.getCenterY();
        if (ex != 0.0 && -slope <= ey / ex && ey / ex <= slope) {
            if (ex > 0.0) {
                x = this.bounds.getMaxX();
                y += this.bounds.getWidth() / 2.0 * ey / ex;
            } else {
                x = this.bounds.getX();
                y -= this.bounds.getWidth() / 2.0 * ey / ex;
            }
        } else if (ey != 0.0) {
            if (ey > 0.0) {
                x += this.bounds.getHeight() / 2.0 * ex / ey;
                y = this.bounds.getMaxY();
            } else {
                x -= this.bounds.getHeight() / 2.0 * ex / ey;
                y = this.bounds.getY();
            }
        }
        return new Point2D.Double(x, y);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        RectangularNode.writeRectangularShape(out, this.bounds);
    }

    private static void writeRectangularShape(ObjectOutputStream out, RectangularShape s) throws IOException {
        out.writeDouble(s.getX());
        out.writeDouble(s.getY());
        out.writeDouble(s.getWidth());
        out.writeDouble(s.getHeight());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bounds = new Rectangle2D.Double();
        RectangularNode.readRectangularShape(in, this.bounds);
    }

    private static void readRectangularShape(ObjectInputStream in, RectangularShape s) throws IOException {
        double x = in.readDouble();
        double y = in.readDouble();
        double width = in.readDouble();
        double height = in.readDouble();
        s.setFrame(x, y, width, height);
    }

    @Override
    public Shape getShape() {
        return this.bounds;
    }

    @Override
    public RectangularNode clone() {
        RectangularNode cloned = (RectangularNode)super.clone();
        cloned.bounds = (Rectangle2D.Double)this.bounds.clone();
        return cloned;
    }
}

