/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.diagram;

import com.horstmann.violet.framework.diagram.AbstractEdge;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class ShapeEdge
extends AbstractEdge {
    public abstract Shape getShape();

    @Override
    public Rectangle2D getBounds(Graphics2D g2) {
        return this.getShape().getBounds();
    }

    @Override
    public boolean contains(Point2D aPoint) {
        double MAX_DIST = 3.0;
        Line2D conn = this.getConnectionPoints();
        if (aPoint.distance(conn.getP1()) <= 3.0 || aPoint.distance(conn.getP2()) <= 3.0) {
            return false;
        }
        Shape p = this.getShape();
        BasicStroke fatStroke = new BasicStroke(6.0f);
        Shape fatPath = fatStroke.createStrokedShape(p);
        return fatPath.contains(aPoint);
    }
}

