/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.file;

import com.horstmann.violet.framework.file.ExtensionFilter;
import com.horstmann.violet.framework.file.FileChooserService;
import com.horstmann.violet.framework.file.FileOpenerHandler;
import com.horstmann.violet.framework.file.FileSaverHandler;
import com.horstmann.violet.framework.file.FileService;
import com.horstmann.violet.framework.gui.DialogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class JFileChooserService
implements FileChooserService {
    private JFileChooser fileChooser = new JFileChooser();

    public JFileChooserService() {
        File initialDirectory = FileService.getLastDir();
        this.fileChooser.setCurrentDirectory(initialDirectory);
    }

    @Override
    public boolean isWebStart() {
        return false;
    }

    @Override
    public FileOpenerHandler open(String defaultDirectory, String defaultFile, ExtensionFilter[] filters) throws FileNotFoundException {
        this.fileChooser.resetChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            this.fileChooser.addChoosableFileFilter(filters[i]);
        }
        if (defaultDirectory != null) {
            this.fileChooser.setCurrentDirectory(new File(defaultDirectory));
        }
        if (defaultFile == null) {
            this.fileChooser.setSelectedFile(null);
        }
        if (defaultFile != null) {
            this.fileChooser.setSelectedFile(new File(defaultFile));
        }
        int response = this.fileChooser.showOpenDialog(null);
        File selectedFile = null;
        if (response == 0) {
            selectedFile = this.fileChooser.getSelectedFile();
        }
        FileOpenerHandler foh = new FileOpenerHandler(){
            InputStream in;
            String name;

            @Override
            public void initialize(File f) throws FileNotFoundException {
                if (f != null) {
                    this.name = f.getPath();
                    this.in = new FileInputStream(f);
                }
            }

            @Override
            public InputStream getInputStream() {
                return this.in;
            }

            @Override
            public String getName() {
                return this.name;
            }
        };
        foh.initialize(selectedFile);
        return foh;
    }

    @Override
    public FileSaverHandler save(String defaultDirectory, String defaultFile, ExtensionFilter filter, String removeExtension, String addExtension) throws FileNotFoundException {
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setFileFilter(filter);
        if (defaultDirectory == null) {
            this.fileChooser.setCurrentDirectory(new File("."));
        }
        if (defaultDirectory != null) {
            this.fileChooser.setCurrentDirectory(new File(defaultDirectory));
        }
        if (defaultFile == null) {
            this.fileChooser.setSelectedFile(new File(""));
        }
        if (defaultFile != null) {
            File f = new File(FileService.editExtension(defaultFile, removeExtension, addExtension));
            this.fileChooser.setSelectedFile(f);
        }
        int response = this.fileChooser.showSaveDialog(null);
        File selectedFile = null;
        if (response == 0) {
            selectedFile = this.fileChooser.getSelectedFile();
            if (addExtension != null && selectedFile.getName().indexOf(".") < 0) {
                selectedFile = new File(selectedFile.getPath() + addExtension);
            }
            if (selectedFile.exists()) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("properties.MenuStrings", Locale.getDefault());
                String message = resourceBundle.getString("dialog.overwrite.ok");
                String title = resourceBundle.getString("dialog.overwrite.title");
                ImageIcon icon = new ImageIcon(this.getClass().getResource(resourceBundle.getString("dialog.overwrite.icon")));
                JOptionPane optionPane = new JOptionPane();
                optionPane.setMessage(message);
                optionPane.setOptionType(0);
                optionPane.setIcon(icon);
                DialogFactory.getInstance().showDialog(optionPane, title, true);
                int result = 1;
                if (!JOptionPane.UNINITIALIZED_VALUE.equals(optionPane.getValue())) {
                    result = (Integer)optionPane.getValue();
                }
                if (result == 1) {
                    selectedFile = null;
                }
            }
        }
        FileSaverHandler fsh = new FileSaverHandler(){
            String name;
            OutputStream out;

            @Override
            public void initialize(File f) throws FileNotFoundException {
                if (f != null) {
                    this.name = f.getPath();
                    this.out = new FileOutputStream(f);
                }
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.out;
            }
        };
        fsh.initialize(selectedFile);
        return fsh;
    }
}

