/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.swingextension.VerticalAutoScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;

public class AboutDialog
extends JDialog {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("properties.AboutStrings", Locale.getDefault());
    private JPanel versionPanel;
    private JPanel authorsPanel;
    private JPanel licensePanel;
    private JPanel systemInfoPanel;
    private VerticalAutoScrollPane authorsScrollPane;
    private JButton nextButton = new JButton();

    public AboutDialog(JFrame parent) {
        super(parent);
        this.setTitle(this.resourceBundle.getString("dialog.title"));
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = this.getButtonPanel();
        this.getContentPane().add((Component)this.getVersionPanel(), "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setLocation(parent);
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        buttonPanel.add((Component)this.nextButton, c);
        c = new GridBagConstraints();
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridx = 1;
        c.gridy = 0;
        JButton closeButton = new JButton(this.resourceBundle.getString("dialog.button.label"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(closeButton);
        buttonPanel.add((Component)closeButton, c);
        return buttonPanel;
    }

    private void setLocation(JFrame parent) {
        Point point = parent.getLocationOnScreen();
        int x = (int)point.getX() + parent.getWidth() / 2;
        int y = (int)point.getY() + parent.getHeight() / 2;
        this.setLocation(x - this.getWidth() / 2, y - this.getHeight() / 2);
    }

    private JPanel getSystemInfoPanel() {
        if (this.systemInfoPanel == null) {
            JTable table = new JTable();
            AboutTableModel tableModel = new AboutTableModel(new String[]{this.resourceBundle.getString("systeminfo.col1"), this.resourceBundle.getString("systeminfo.col2")});
            try {
                Enumeration<?> e = System.getProperties().propertyNames();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    String value = System.getProperty(prop);
                    tableModel.addEntry(new String[]{prop, value});
                }
            }
            catch (AccessControlException e) {
                // empty catch block
            }
            table.setModel(tableModel);
            table.getColumnModel().getColumn(0).setPreferredWidth(170);
            table.getColumnModel().getColumn(1).setPreferredWidth(380);
            JScrollPane pane = new JScrollPane();
            pane.getViewport().add(table);
            this.systemInfoPanel = new JPanel(new BorderLayout());
            this.systemInfoPanel.add(pane);
        }
        this.nextButton.setText(this.resourceBundle.getString("dialog.button.show_version"));
        this.removeActionListener(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.getContentPane().remove(AboutDialog.this.getSystemInfoPanel());
                AboutDialog.this.getContentPane().add((Component)AboutDialog.this.getVersionPanel(), "Center");
                AboutDialog.this.getContentPane().repaint();
            }
        });
        return this.systemInfoPanel;
    }

    private JPanel getAuthorsPanel() {
        if (this.authorsPanel == null) {
            String imagePath = this.resourceBundle.getString("authors.banner");
            JLabel image = new JLabel(new ImageIcon(this.getClass().getResource(imagePath)));
            JTextPane tp = new JTextPane();
            try {
                URL url = this.getClass().getResource(this.resourceBundle.getString("authors.file"));
                tp.setPage(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.authorsScrollPane = new VerticalAutoScrollPane();
            this.authorsScrollPane.setBackground(new Color(255, 255, 255));
            this.authorsScrollPane.setForeground(new Color(0, 0, 0));
            this.authorsScrollPane.setOpaque(true);
            this.authorsScrollPane.setBorder(new EmptyBorder(20, 20, 20, 20));
            this.authorsScrollPane.getViewport().add(tp);
            this.authorsPanel = new JPanel(new BorderLayout());
            this.authorsPanel.add((Component)image, "North");
            this.authorsPanel.add((Component)this.authorsScrollPane, "Center");
        }
        this.nextButton.setText(this.resourceBundle.getString("dialog.button.show_license"));
        this.removeActionListener(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.getContentPane().remove(AboutDialog.this.getAuthorsPanel());
                AboutDialog.this.authorsScrollPane.reset();
                AboutDialog.this.getContentPane().add((Component)AboutDialog.this.getLicensePanel(), "Center");
                AboutDialog.this.getContentPane().repaint();
            }
        });
        this.authorsScrollPane.animate();
        return this.authorsPanel;
    }

    private JPanel getLicensePanel() {
        if (this.licensePanel == null) {
            JTextPane tp = new JTextPane();
            JScrollPane js = new JScrollPane();
            js.getViewport().add(tp);
            try {
                URL url = this.getClass().getResource(this.resourceBundle.getString("license.file"));
                tp.setPage(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.licensePanel = new JPanel(new BorderLayout());
            this.licensePanel.add(js);
        }
        this.nextButton.setText(this.resourceBundle.getString("dialog.button.show_systeminfo"));
        this.removeActionListener(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.getContentPane().remove(AboutDialog.this.getLicensePanel());
                AboutDialog.this.getContentPane().add((Component)AboutDialog.this.getSystemInfoPanel(), "Center");
                AboutDialog.this.getContentPane().repaint();
            }
        });
        return this.licensePanel;
    }

    private JPanel getVersionPanel() {
        if (this.versionPanel == null) {
            String imagePath = this.resourceBundle.getString("dialog.about.image");
            JLabel image = new JLabel(new ImageIcon(this.getClass().getResource(imagePath)));
            JLabel text = new JLabel(this.resourceBundle.getString("app.version.text"));
            text.setBorder(new EmptyBorder(0, 0, 0, 4));
            this.versionPanel = new JPanel();
            this.versionPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 10;
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            this.versionPanel.add((Component)image, c);
            c = new GridBagConstraints();
            c.anchor = 13;
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 1;
            this.versionPanel.add((Component)text, c);
        }
        this.nextButton.setText(this.resourceBundle.getString("dialog.button.show_authors"));
        this.removeActionListener(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.getContentPane().remove(AboutDialog.this.getVersionPanel());
                AboutDialog.this.getContentPane().add((Component)AboutDialog.this.getAuthorsPanel(), "Center");
                AboutDialog.this.getContentPane().repaint();
            }
        });
        return this.versionPanel;
    }

    private void removeActionListener(JButton button) {
        ActionListener[] listeners = button.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            button.removeActionListener(listeners[i]);
        }
    }

    private class AboutTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private List<String[]> data = new ArrayList<String[]>();

        public AboutTableModel(String[] columnNames) {
            this.columnNames = columnNames;
        }

        public void addEntry(String[] entry) {
            this.data.add(entry);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String[] entry = this.data.get(row);
            return entry[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

