/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.diagram.GraphModificationListener;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.gui.DiagramPanelListener;
import com.horstmann.violet.framework.gui.GraphPanel;
import com.horstmann.violet.framework.gui.GraphPanelEventType;
import com.horstmann.violet.framework.gui.GraphPanelListener;
import com.horstmann.violet.framework.gui.StatusBar;
import com.horstmann.violet.framework.gui.sidebar.SideBar;
import com.horstmann.violet.framework.gui.sidebar.SideToolPanel;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.network.NetworkAction;
import com.horstmann.violet.framework.util.UniqueIDGenerator;
import com.horstmann.violet.product.diagram.activity.ActivityDiagramGraph;
import com.horstmann.violet.product.diagram.classes.ClassDiagramGraph;
import com.horstmann.violet.product.diagram.object.ObjectDiagramGraph;
import com.horstmann.violet.product.diagram.sequence.SequenceDiagramGraph;
import com.horstmann.violet.product.diagram.state.StateDiagramGraph;
import com.horstmann.violet.product.diagram.usecase.UseCaseDiagramGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class DiagramPanel
extends JPanel {
    private Graph graph;
    private GraphPanel graphPanel;
    private SideBar sideBar;
    private JScrollPane scrollableGraphPanel;
    private StatusBar statusBar;
    private String filePath;
    private String title;
    private Vector<DiagramPanelListener> listeners = new Vector();
    private String id;
    private DiagramPanel instance = this;
    private NetworkAction networkAction;

    public DiagramPanel(Graph aGraph) {
        this.setGraph(aGraph);
    }

    public DiagramPanel(String id) {
        this.id = id;
    }

    public void setGraph(Graph aGraph) {
        this.reset();
        this.graph = aGraph;
        this.setDefaultTitle(this.graph);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        SideBar sBar = this.getSideBar(aGraph);
        JScrollPane scrollGPanel = this.getScrollableGraphPanel(aGraph, sBar);
        StatusBar statBar = this.getStatusBar(sBar);
        this.add((Component)scrollGPanel, "Center");
        this.add((Component)sBar, "East");
        this.add((Component)statBar, "South");
        this.addGraphPanelListener();
        this.graph.addGraphModificationListener(new GraphModificationListener(){

            @Override
            public void childAttached(Graph g, int index, Node p, Node c) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void childDetached(Graph g, int index, Node p, Node c) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void edgeAdded(Graph g, Edge e) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void edgeRemoved(Graph g, Edge e) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void nodeAdded(Graph g, Node n) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void nodeRemoved(Graph g, Node n) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DiagramPanel.this.updateTitle();
            }

            @Override
            public void nodeMoved(Graph g, Node n, double dx, double dy) {
                DiagramPanel.this.updateTitle();
            }
        });
    }

    private void reset() {
        this.removeAll();
        this.graph = null;
        this.graphPanel = null;
        this.sideBar = null;
        this.scrollableGraphPanel = null;
        this.statusBar = null;
        this.filePath = null;
        this.title = null;
        this.listeners = new Vector();
    }

    public SideBar getSideBar(Graph graph) {
        if (this.sideBar == null) {
            this.sideBar = new SideBar(this);
        }
        return this.sideBar;
    }

    public JScrollPane getScrollableGraphPanel(Graph graph, SideBar sideBar) {
        if (this.scrollableGraphPanel == null) {
            GraphPanel panel = this.getGraphPanel();
            panel.repaint();
            final SideToolPanel sideToolPanel = sideBar.getSideToolPanel();
            panel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        sideToolPanel.reset();
                    }
                }
            });
            panel.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int scroll = e.getUnitsToScroll();
                    if (scroll > 0) {
                        sideToolPanel.selectNextButton();
                    }
                    if (scroll < 0) {
                        sideToolPanel.selectPreviousButton();
                    }
                }
            });
            panel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        sideToolPanel.reset();
                    }
                }
            });
            sideBar.getSideToolPanel().addListener(panel.getToolListener());
            this.scrollableGraphPanel = new JScrollPane(panel);
            this.scrollableGraphPanel.setBackground(ThemeManager.getInstance().getTheme().getWHITE_COLOR());
            this.scrollableGraphPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        return this.scrollableGraphPanel;
    }

    private StatusBar getStatusBar(SideBar sideBar) {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar(sideBar);
        }
        return this.statusBar;
    }

    public GraphPanel getGraphPanel() {
        if (this.graphPanel == null) {
            this.graphPanel = new GraphPanel(this.graph);
        }
        return this.graphPanel;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newValue) {
        this.title = newValue;
        this.fireTitleChanged(newValue);
    }

    private void setDefaultTitle(Graph graph) {
        ResourceBundle rb = ResourceBundle.getBundle("properties.MenuStrings", Locale.getDefault());
        this.title = graph instanceof ClassDiagramGraph ? rb.getString("file.new.class_diagram.text") : (graph instanceof ObjectDiagramGraph ? rb.getString("file.new.object_diagram.text") : (graph instanceof SequenceDiagramGraph ? rb.getString("file.new.sequence_diagram.text") : (graph instanceof StateDiagramGraph ? rb.getString("file.new.state_diagram.text") : (graph instanceof UseCaseDiagramGraph ? rb.getString("file.new.usecase_diagram.text") : (graph instanceof ActivityDiagramGraph ? rb.getString("file.new.activity_diagram.text") : "Unknown")))));
    }

    private void updateTitle() {
        String title = this.getTitle();
        if (title == null) {
            return;
        }
        if (this.isSaveNeeded() && !title.endsWith("*")) {
            this.setTitle(title + "*");
            return;
        }
        if (!this.isSaveNeeded() && title.endsWith("*")) {
            this.setTitle(title.substring(0, title.length() - 1));
            return;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String path) {
        this.filePath = path;
        File file = new File(path);
        this.setTitle(file.getName());
    }

    public boolean isSaveNeeded() {
        return this.getGraphPanel().isDirty();
    }

    public void setSaveNeeded(boolean isSaveNeeded) {
        if (!isSaveNeeded) {
            this.getGraphPanel().notifySaved();
        }
        this.fireSaveNeeded();
        this.updateTitle();
    }

    private void addGraphPanelListener() {
        this.getGraphPanel().addListener(new GraphPanelListener(){

            @Override
            public void eventHappenedOnEdge(GraphPanelEventType type, Edge e) {
                if (type.equals(GraphPanelEventType.EDGE_ADDED)) {
                    DiagramPanel.this.getNetworkAction().sendAddedEdge(DiagramPanel.this.instance, e);
                }
                if (type.equals(GraphPanelEventType.EDGE_UDPATED)) {
                    DiagramPanel.this.getNetworkAction().sendModifiedEdge(DiagramPanel.this.instance, e);
                }
                if (type.equals(GraphPanelEventType.EDGE_REMOVED)) {
                    DiagramPanel.this.getNetworkAction().sendRemovedEdge(DiagramPanel.this.instance, e);
                }
            }

            @Override
            public void eventHappenedOnNode(GraphPanelEventType type, Node n) {
                if (type.equals(GraphPanelEventType.NODE_ADDED)) {
                    DiagramPanel.this.getNetworkAction().sendAddedNode(DiagramPanel.this.instance, n);
                }
                if (type.equals(GraphPanelEventType.NODE_UDPATED)) {
                    DiagramPanel.this.getNetworkAction().sendModifiedNode(DiagramPanel.this.instance, n);
                }
                if (type.equals(GraphPanelEventType.NODE_REMOVED)) {
                    DiagramPanel.this.getNetworkAction().sendRemovedNode(DiagramPanel.this.instance, n);
                }
            }
        });
    }

    public synchronized void addListener(DiagramPanelListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    private void fireTitleChanged(String newTitle) {
        Vector<DiagramPanelListener> tl = this.cloneListeners();
        int size = tl.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            DiagramPanelListener aListener = tl.elementAt(i);
            aListener.titleChanged(newTitle);
        }
    }

    private synchronized Vector<DiagramPanelListener> cloneListeners() {
        return (Vector)this.listeners.clone();
    }

    public void fireMustOpenFile(URL url) {
        Vector<DiagramPanelListener> tl = this.cloneListeners();
        int size = tl.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            DiagramPanelListener l = tl.elementAt(i);
            l.mustOpenfile(url);
        }
    }

    private void fireSaveNeeded() {
        Vector<DiagramPanelListener> tl = this.cloneListeners();
        int size = tl.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            DiagramPanelListener l = tl.elementAt(i);
            l.graphCouldBeSaved();
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = UniqueIDGenerator.getNewId();
        }
        return this.id;
    }

    private NetworkAction getNetworkAction() {
        if (this.networkAction == null) {
            this.networkAction = new NetworkAction();
        }
        return this.networkAction;
    }
}

