/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui;

import com.horstmann.violet.framework.diagram.Graph;
import com.horstmann.violet.framework.gui.theme.Theme;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.resources.ResourceFactory;
import com.horstmann.violet.framework.swingextension.RolloverButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class PrintPanel
extends JPanel {
    private PrintPreviewCanvas canvas;
    private PageFormat pageFormat;
    private PrintRequestAttributeSet attributes;
    private Graph graph;
    private Rectangle2D bounds;
    private double scaleGraph = 1.0;

    public PrintPanel(Graph gr) {
        this.graph = gr;
        PrinterJob job = PrinterJob.getPrinterJob();
        this.pageFormat = job.defaultPage();
        this.attributes = new HashPrintRequestAttributeSet();
        this.layoutUI();
    }

    public void layoutUI() {
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        Theme cLAF = ThemeManager.getInstance().getTheme();
        buttonPanel.setBackground(cLAF.getROLLOVERBUTTON_DEFAULT_COLOR());
        RolloverButtonUI buttonUI = new RolloverButtonUI(cLAF.getROLLOVERBUTTON_ROLLOVER_COLOR(), cLAF.getROLLOVERBUTTON_ROLLOVER_BORDER_COLOR(), cLAF.getROLLOVERBUTTON_DEFAULT_COLOR());
        ResourceBundle bundle = ResourceBundle.getBundle("properties.PrintStrings", Locale.getDefault());
        ResourceFactory factory = new ResourceFactory(bundle);
        JButton moreButton = factory.createButton("dialog.print.more");
        moreButton.setUI(buttonUI);
        buttonPanel.add(moreButton);
        moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintPanel.this.scaleGraph *= Math.sqrt(2.0);
                PrintPanel.this.canvas.repaint();
            }
        });
        JButton fewerButton = factory.createButton("dialog.print.fewer");
        fewerButton.setUI(buttonUI);
        buttonPanel.add(fewerButton);
        fewerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintPanel.this.scaleGraph /= Math.sqrt(2.0);
                PrintPanel.this.canvas.repaint();
            }
        });
        JButton onePageButton = factory.createButton("dialog.print.one");
        onePageButton.setUI(buttonUI);
        buttonPanel.add(onePageButton);
        onePageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                while (PrintPanel.this.getRows() * PrintPanel.this.getCols() > 1) {
                    PrintPanel.this.scaleGraph /= Math.sqrt(2.0);
                }
                PrintPanel.this.canvas.repaint();
            }
        });
        JButton pageSetupButton = factory.createButton("dialog.print.page");
        pageSetupButton.setUI(buttonUI);
        buttonPanel.add(pageSetupButton);
        pageSetupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat newPageFormat = job.pageDialog(PrintPanel.this.attributes);
                if (newPageFormat != null) {
                    PrintPanel.this.pageFormat = newPageFormat;
                }
                PrintPanel.this.canvas.repaint();
            }
        });
        JButton printButton = factory.createButton("dialog.print.print");
        printButton.setUI(buttonUI);
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    job.setPageable(PrintPanel.this.makeBook());
                    if (job.printDialog(PrintPanel.this.attributes)) {
                        PrintPanel.this.pageFormat = job.validatePage(PrintPanel.this.pageFormat);
                        job.print(PrintPanel.this.attributes);
                    }
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        });
        buttonPanel.add(printButton);
        this.add((Component)buttonPanel, "North");
        this.canvas = new PrintPreviewCanvas();
        JPanel canvasPanel = new JPanel();
        canvasPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        canvasPanel.setOpaque(false);
        canvasPanel.setLayout(new BorderLayout());
        canvasPanel.add((Component)this.canvas, "Center");
        this.add((Component)canvasPanel, "Center");
    }

    private Book makeBook() {
        Book book = new Book();
        final int pageCount = this.getRows() * this.getCols();
        Printable printable = new Printable(){

            @Override
            public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                Graphics2D g2 = (Graphics2D)g;
                if (page > pageCount) {
                    return 1;
                }
                g2.translate(pf.getImageableX(), pf.getImageableY());
                this.drawPage(g2, pf, page);
                return 0;
            }

            public void drawPage(Graphics2D g2, PageFormat pf, int page) {
                int cols = PrintPanel.this.getCols();
                int row = page / cols;
                int col = page % cols;
                double px = PrintPanel.this.pageFormat.getImageableWidth();
                double py = PrintPanel.this.pageFormat.getImageableHeight();
                g2.clip(new Rectangle2D.Double(0.0, 0.0, px, py));
                g2.translate((double)(-col) * px, (double)(-row) * py);
                g2.scale((float)PrintPanel.this.scaleGraph, (float)PrintPanel.this.scaleGraph);
                g2.translate((float)(-PrintPanel.this.bounds.getX()), (float)(-PrintPanel.this.bounds.getY()));
                g2.setColor(Color.BLACK);
                g2.setBackground(Color.WHITE);
                PrintPanel.this.graph.draw(g2, null);
            }
        };
        book.append(printable, this.pageFormat, pageCount);
        return book;
    }

    private int getCols() {
        return (int)Math.max(1.0, Math.ceil(this.bounds.getWidth() * this.scaleGraph / this.pageFormat.getImageableWidth()));
    }

    private int getRows() {
        return (int)Math.max(1.0, Math.ceil(this.bounds.getHeight() * this.scaleGraph / this.pageFormat.getImageableHeight()));
    }

    class PrintPreviewCanvas
    extends JComponent {
        private static final int DEFAULT_WIDTH = 450;
        private static final int DEFAULT_HEIGHT = 300;

        PrintPreviewCanvas() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(450, 300);
        }

        @Override
        public void paintComponent(Graphics g) {
            double yoff;
            double xoff;
            double scalePagesToCanvas;
            Graphics2D g2 = (Graphics2D)g;
            PrintPanel.this.bounds = PrintPanel.this.graph.getBounds(g2);
            double px = PrintPanel.this.pageFormat.getImageableWidth();
            double py = PrintPanel.this.pageFormat.getImageableHeight();
            int cols = PrintPanel.this.getCols();
            int rows = PrintPanel.this.getRows();
            double dx = px * (double)PrintPanel.this.getCols();
            double dy = py * (double)PrintPanel.this.getRows();
            double sx = this.getWidth() - 1;
            double sy = this.getHeight() - 1;
            if (dx / dy < sx / sy) {
                scalePagesToCanvas = sy / dy;
                xoff = 0.5 * (sx - scalePagesToCanvas * dx);
                yoff = 0.0;
            } else {
                scalePagesToCanvas = sx / dx;
                xoff = 0.0;
                yoff = 0.5 * (sy - scalePagesToCanvas * dy);
            }
            g2.translate((float)xoff, (float)yoff);
            g2.scale((float)scalePagesToCanvas, (float)scalePagesToCanvas);
            Rectangle2D.Double pages = new Rectangle2D.Double(0.0, 0.0, px * (double)cols, py * (double)rows);
            g2.setPaint(Color.WHITE);
            g2.fill(pages);
            g2.setPaint(Color.BLACK);
            AffineTransform oldTransform = g2.getTransform();
            g2.scale((float)PrintPanel.this.scaleGraph, (float)PrintPanel.this.scaleGraph);
            g2.translate((float)(-PrintPanel.this.bounds.getX()), (float)(-PrintPanel.this.bounds.getY()));
            PrintPanel.this.graph.draw(g2, null);
            g2.setTransform(oldTransform);
            g2.setPaint(Color.LIGHT_GRAY);
            for (int i = 0; i < cols; ++i) {
                for (int j = 0; j < rows; ++j) {
                    Rectangle2D.Double page = new Rectangle2D.Double((double)i * px, (double)j * py, px, py);
                    g2.draw(page);
                }
            }
        }
    }
}

