/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.gui.sidebar;

import com.horstmann.violet.framework.gui.DiagramPanel;
import com.horstmann.violet.framework.gui.sidebar.SideShortcutMandatoryPanel;
import com.horstmann.violet.framework.gui.sidebar.SideShortcutOptionalPanel;
import com.horstmann.violet.framework.gui.sidebar.SideToolPanel;
import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.swingextension.CollapsiblePane;
import com.l2fprod.common.swing.JTaskPane;
import com.l2fprod.common.swing.JTaskPaneGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.border.MatteBorder;

public class SideBar
extends CollapsiblePane {
    public static final int SIDE_MANDATORY_SHORTCUT_PANEL = 0;
    public static final int SIDE_TOOL_PANEL = 1;
    public static final int SIDE_OPTIONAL_SHORTCUT_PANEL = 2;
    private DiagramPanel diagramPanel;
    private SideToolPanel sideToolPanel;
    private SideShortcutMandatoryPanel sideShortcutMandatoryPanel;
    private SideShortcutOptionalPanel sideShortcutOptionalPanel;
    private JTaskPane taskPane;
    private ResourceBundle resourceBundle;

    public SideBar(DiagramPanel diagramPanel) {
        this.diagramPanel = diagramPanel;
        this.taskPane = new JTaskPane();
        this.add(this.taskPane);
        this.show(0, true);
        this.show(1, true);
        this.show(2, true);
        this.setBorder(new MatteBorder(0, 1, 0, 0, ThemeManager.getInstance().getTheme().getSIDEBAR_BORDER_COLOR()));
        this.fixWidth();
    }

    private void fixWidth() {
        JLabel sizer = new JLabel();
        sizer.setPreferredSize(new Dimension(215, 1));
        this.taskPane.add(sizer);
    }

    public void show(int sidePanelId, boolean isVisible) {
        switch (sidePanelId) {
            case 0: {
                if (!isVisible) break;
                this.addElement(this.getSideShortcutMandatoryPanel(), this.getSideBarResourceBundle().getString("title.standardbuttons"));
                break;
            }
            case 1: {
                if (!isVisible) break;
                this.addElement(this.getSideToolPanel(), this.getSideBarResourceBundle().getString("title.diagramtools"));
                break;
            }
            case 2: {
                if (!isVisible) break;
                this.addElement(this.getSideShortcutOptionalPanel(), this.getSideBarResourceBundle().getString("title.extendedfunctions"));
                break;
            }
        }
    }

    private void addElement(Component c, String title) {
        JTaskPaneGroup group = new JTaskPaneGroup();
        group.setFont(group.getFont().deriveFont(0));
        group.setTitle(title);
        group.setLayout(new BorderLayout());
        group.add(c, "Center");
        this.taskPane.add(group);
    }

    public SideToolPanel getSideToolPanel() {
        if (this.sideToolPanel == null) {
            this.sideToolPanel = new SideToolPanel(this.diagramPanel.getGraphPanel().getGraph());
        }
        return this.sideToolPanel;
    }

    private SideShortcutMandatoryPanel getSideShortcutMandatoryPanel() {
        if (this.sideShortcutMandatoryPanel == null) {
            this.sideShortcutMandatoryPanel = new SideShortcutMandatoryPanel(this.diagramPanel, this.getSideBarResourceBundle());
        }
        return this.sideShortcutMandatoryPanel;
    }

    private SideShortcutOptionalPanel getSideShortcutOptionalPanel() {
        if (this.sideShortcutOptionalPanel == null) {
            this.sideShortcutOptionalPanel = new SideShortcutOptionalPanel(this.diagramPanel, this.getSideBarResourceBundle());
        }
        return this.sideShortcutOptionalPanel;
    }

    private ResourceBundle getSideBarResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle("properties.SideBarStrings", Locale.getDefault());
        }
        return this.resourceBundle;
    }
}

