/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.network.sender;

import com.horstmann.violet.framework.network.sender.HTTPSender;
import com.horstmann.violet.framework.network.sender.ISender;
import java.net.URL;

public class SenderFactory {
    private static SenderFactory instance;

    private SenderFactory() {
    }

    public static SenderFactory getInstance() {
        if (instance == null) {
            instance = new SenderFactory();
        }
        return instance;
    }

    public ISender createSender(URL senderURL) {
        String protocol = senderURL.getProtocol();
        if (protocol == null) {
            throw new RuntimeException("Can't read network protocol");
        }
        if (protocol.toLowerCase().equals("http")) {
            return new HTTPSender();
        }
        throw new RuntimeException("Can't recognize network protcol");
    }
}

