/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.swingextension;

import com.horstmann.violet.framework.gui.theme.ThemeManager;
import com.horstmann.violet.framework.swingextension.CustomToggleButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CustomToggleButton
extends JPanel {
    private boolean isSelected = false;
    private JLabel iconLabel = new JLabel();
    private JLabel textLabel = new JLabel();
    private static final int HGAP = 4;
    private static final int VGAP = 2;
    private static final int MAX_TEXT_WIDTH = 150;

    public CustomToggleButton(String text, Icon icon, Color selectedColor, Color selectedBorderColor, Color unselectedColor) {
        this.iconLabel.setIcon(icon);
        this.textLabel.setText(text);
        this.textLabel.setFont(ThemeManager.getInstance().getTheme().getTOGGLEBUTTON_FONT());
        this.iconLabel.setBorder(new EmptyBorder(2, 4, 2, 4));
        this.textLabel.setBorder(new EmptyBorder(2, 0, 2, 4));
        this.setToolTipText(text);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                CustomToggleButton.this.isSelected = true;
                CustomToggleButton.this.repaint();
            }
        });
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.iconLabel);
        this.add(this.textLabel);
        this.setUI(new CustomToggleButtonUI(selectedColor, selectedBorderColor, unselectedColor));
        this.textLabel.setPreferredSize(new Dimension(150, (int)this.getBounds().getHeight()));
        this.setPreferredSize(new Dimension(150, (int)this.getPreferredSize().getHeight()));
    }

    @Override
    public void setPreferredSize(Dimension p) {
        super.setPreferredSize(p);
        this.textLabel.setPreferredSize(new Dimension((int)p.getWidth(), (int)this.getBounds().getHeight()));
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.repaint();
    }
}

