/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.framework.util;

import com.horstmann.violet.framework.gui.DialogFactory;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class VersionChecker {
    public void check(String desiredVersion) {
        boolean versionOk;
        String actualVersion = System.getProperty("java.version");
        try {
            versionOk = VersionChecker.versionCompare(actualVersion, desiredVersion) >= 0;
        }
        catch (NumberFormatException exception) {
            versionOk = false;
        }
        if (!versionOk) {
            ResourceBundle resources = ResourceBundle.getBundle("properties.OtherStrings", Locale.getDefault());
            String versionError = resources.getString("dialog.error_version.text");
            MessageFormat formatter = new MessageFormat(versionError);
            String message = formatter.format(new Object[]{desiredVersion});
            String title = resources.getString("dialog.error_version.title");
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(message);
            DialogFactory.getInstance().showDialog(optionPane, title, true);
            System.exit(1);
        }
    }

    public static int versionCompare(String v1, String v2) {
        StringTokenizer t1 = new StringTokenizer(v1, "._");
        StringTokenizer t2 = new StringTokenizer(v2, "._");
        while (t1.hasMoreTokens()) {
            int n2;
            if (!t2.hasMoreTokens()) {
                return 1;
            }
            int n1 = Integer.parseInt(t1.nextToken());
            int d = n1 - (n2 = Integer.parseInt(t2.nextToken()));
            if (d == 0) continue;
            return d;
        }
        return t2.hasMoreTokens() ? -1 : 0;
    }
}

