/*
 * Decompiled with CFR 0.152.
 */
package com.horstmann.violet.product.diagram.sequence;

import com.horstmann.violet.framework.diagram.Direction;
import com.horstmann.violet.framework.diagram.Edge;
import com.horstmann.violet.framework.diagram.Grid;
import com.horstmann.violet.framework.diagram.MultiLineString;
import com.horstmann.violet.framework.diagram.Node;
import com.horstmann.violet.framework.diagram.RectangularNode;
import com.horstmann.violet.product.diagram.common.PointNode;
import com.horstmann.violet.product.diagram.sequence.ActivationBarNode;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class LifelineNode
extends RectangularNode {
    private transient double topHeight;
    private MultiLineString name = new MultiLineString();
    private static int DEFAULT_TOP_HEIGHT = 60;
    private static int DEFAULT_WIDTH = 80;
    private static int DEFAULT_HEIGHT = 120;

    public LifelineNode() {
        this.name.setUnderlined(true);
        this.setBounds(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_HEIGHT));
        this.topHeight = DEFAULT_TOP_HEIGHT;
    }

    @Override
    public boolean contains(Point2D p) {
        Rectangle2D bounds = this.getBounds();
        return bounds.getX() <= p.getX() && p.getX() <= bounds.getX() + bounds.getWidth();
    }

    @Override
    public void draw(Graphics2D g2) {
        super.draw(g2);
        Rectangle2D top = this.getTopRectangle();
        g2.draw(top);
        this.name.draw(g2, top);
        double xmid = this.getBounds().getCenterX();
        Line2D.Double line = new Line2D.Double(xmid, top.getMaxY(), xmid, this.getBounds().getMaxY());
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f));
        g2.draw(line);
        g2.setStroke(oldStroke);
    }

    public Rectangle2D getTopRectangle() {
        return new Rectangle2D.Double(this.getBounds().getX(), this.getBounds().getY(), this.getBounds().getWidth(), this.topHeight);
    }

    @Override
    public Shape getShape() {
        return this.getTopRectangle();
    }

    @Override
    public boolean checkAddEdge(Edge e, Point2D p1, Point2D p2) {
        return false;
    }

    @Override
    public Point2D getConnectionPoint(Direction d) {
        if (d.getX() > 0.0) {
            return new Point2D.Double(this.getBounds().getMaxX(), this.getTopRectangle().getMinY() + this.topHeight / 2.0);
        }
        return new Point2D.Double(this.getBounds().getX(), this.getTopRectangle().getMinY() + this.topHeight / 2.0);
    }

    @Override
    public void layout(Graphics2D g2, Grid grid) {
        Rectangle2D b = this.name.getBounds(g2);
        b.add(new Rectangle2D.Double(0.0, 0.0, DEFAULT_WIDTH, DEFAULT_TOP_HEIGHT));
        Rectangle2D.Double top = new Rectangle2D.Double(this.getLocation().getX(), this.getLocation().getY(), b.getWidth(), b.getHeight());
        grid.snap(top);
        this.topHeight = ((RectangularShape)top).getHeight();
    }

    public void setName(MultiLineString n) {
        this.name = n;
    }

    public MultiLineString getName() {
        return this.name;
    }

    @Override
    public boolean checkAddNode(Node n, Point2D p) {
        return n instanceof ActivationBarNode || n instanceof PointNode;
    }

    @Override
    public LifelineNode clone() {
        LifelineNode cloned = (LifelineNode)super.clone();
        cloned.name = this.name.clone();
        return cloned;
    }
}

