/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class PgsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsProgressBarUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = jComponent.getSize();
        graphics2D.setColor(jComponent.getBackground());
        graphics2D.fill(new Rectangle(0, 0, dimension.width, dimension.height));
        super.paint(graphics, jComponent);
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getAmountFull(insets, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            if (PgsUtils.isLeftToRight(jComponent)) {
                if (this.progressBar.isEnabled()) {
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), 0.0f, n2 / 2, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                } else {
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientStart"), 0.0f, n2 / 2, UIManager.getColor("ProgressBar.innerDisabledGradientEnd"), true));
                }
                graphics2D.fillRect(insets.left + 2, insets.top + 2, n3 + insets.left - insets.right - 4, n2 - 4);
                graphics2D.setColor(UIManager.getColor(this.progressBar.isEnabled() ? "ProgressBar.innerBorderColor" : "ProgressBar.innerDisabledBorderColor"));
                graphics2D.drawRect(insets.left + 1, insets.top + 1, n3 + insets.left - insets.right - 3, n2 - 3);
            } else {
                if (this.progressBar.isEnabled()) {
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), 0.0f, n2 / 2, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                } else {
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientStart"), 0.0f, n2 / 2, UIManager.getColor("ProgressBar.innerDisabledGradientEnd"), true));
                }
                graphics2D.fillRect(insets.left + n - n3 + 2, insets.top + 2, n3 + insets.left - insets.right - 4, n2 - 4);
                graphics2D.setColor(UIManager.getColor(this.progressBar.isEnabled() ? "ProgressBar.innerBorderColor" : "ProgressBar.innerDisabledBorderColor"));
                graphics2D.drawRect(insets.left + n - n3 - 1, insets.top + 1, n3 + insets.left - insets.right - 3, n2 - 3);
            }
        } else {
            if (this.progressBar.isEnabled()) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), n / 2, 0.0f, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientStart"), n / 2, 0.0f, UIManager.getColor("ProgressBar.innerDisabledGradientEnd"), true));
            }
            graphics2D.fillRect(insets.left + 2, insets.top + n2 - insets.bottom - n3 - 3, n - insets.left - 3, n3 + 2);
            graphics2D.setColor(UIManager.getColor(this.progressBar.isEnabled() ? "ProgressBar.innerBorderColor" : "ProgressBar.innerDisabledBorderColor"));
            graphics2D.drawRect(insets.left + 1, insets.top + n2 - insets.bottom - n3 - 4, n - insets.left - 2, n3 + 3);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, insets.left, insets.top, n, n2, n3, insets);
        }
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            if (this.progressBar.getOrientation() == 0) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), 0.0f, n2 / 2, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                graphics2D.fillRect(this.boxRect.x + insets.left + 2, this.boxRect.y + 2, this.boxRect.width + insets.left - insets.right - 4, this.boxRect.height - 4);
                graphics2D.setColor(UIManager.getColor("ProgressBar.innerBorderColor"));
                graphics2D.drawRect(this.boxRect.x + insets.left + 1, this.boxRect.y + 1, this.boxRect.width + insets.left - insets.right - 3, this.boxRect.height - 3);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("ProgressBar.innerGradientStart"), n / 2, 0.0f, UIManager.getColor("ProgressBar.innerGradientEnd"), true));
                graphics2D.fillRect(this.boxRect.x + insets.left + 1, this.boxRect.y + insets.top + 1, this.boxRect.width + insets.left - insets.right - 4, this.boxRect.height - 2 - insets.bottom);
                graphics2D.setColor(UIManager.getColor("ProgressBar.innerBorderColor"));
                graphics2D.drawRect(this.boxRect.x + insets.left, this.boxRect.y + insets.top, this.boxRect.width + insets.left - insets.right - 3, this.boxRect.height - 1 - insets.bottom);
            }
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n, n2, this.boxRect.x, this.boxRect.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n, n2, this.boxRect.y, this.boxRect.height, insets);
            }
        }
    }

    private void paintString(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        PgsUtils.installAntialiasing(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n, n2, n3, n4);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(this.getSelectionBackground());
            graphics2D.drawString(string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n5, n2, n6, n4);
            graphics.drawString(string, point.x, point.y);
        } else {
            graphics2D.setColor(this.getSelectionBackground());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics2D.setFont(this.progressBar.getFont().deriveFont(affineTransform));
            point = this.getStringPlacement(graphics2D, string, n, n2, n3, n4);
            graphics2D.drawString(string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n, n5, n3, n6);
            graphics2D.drawString(string, point.x, point.y);
        }
        graphics2D.setClip(rectangle);
        PgsUtils.uninstallAntialiasing(graphics);
    }
}

