/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.IOException;
import org.apache.ws.jaxme.js.AbstractJavaMethod;
import org.apache.ws.jaxme.js.IndentationTarget;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.Parameter;

public class JavaConstructor
extends AbstractJavaMethod {
    JavaConstructor(String pName, JavaSource.Protection pProtection) {
        super(pName, (JavaQName)null, pProtection);
    }

    public String getName() {
        String name = super.getName();
        int offset = name.lastIndexOf(36);
        if (offset > -1) {
            return name.substring(offset + 1);
        }
        return name;
    }

    protected void writeHeader(IndentationTarget pTarget) throws IOException {
        if (pTarget.isInterface()) {
            return;
        }
        pTarget.indent(0);
        JavaSource.Protection protection = this.getProtection();
        if (protection != null && !protection.equals(JavaSource.DEFAULT_PROTECTION)) {
            pTarget.write(this.getProtection().toString());
            pTarget.write(" ");
        }
        pTarget.write(this.getName());
        pTarget.write("(");
        Parameter[] params = this.getParams();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                pTarget.write(", ");
            }
            Parameter p = params[i];
            pTarget.write(pTarget.asString(p.getType()));
            pTarget.write(" ");
            pTarget.write(p.getName());
        }
        pTarget.write(")");
        JavaQName[] exceptions = this.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                pTarget.write(", ");
            } else {
                pTarget.write(" throws ");
            }
            pTarget.write(pTarget.asString(exceptions[i]));
        }
        pTarget.write(" {");
        pTarget.write();
    }
}

