/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.db2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.db2.BufferPool;
import org.apache.ws.jaxme.sqls.db2.DB2ColumnImpl;
import org.apache.ws.jaxme.sqls.db2.DB2SQLFactory;
import org.apache.ws.jaxme.sqls.db2.DB2SQLGeneratorImpl;
import org.apache.ws.jaxme.sqls.db2.DB2SchemaImpl;
import org.apache.ws.jaxme.sqls.db2.DB2TableImpl;
import org.apache.ws.jaxme.sqls.db2.PageSize;
import org.apache.ws.jaxme.sqls.db2.TableSpace;
import org.apache.ws.jaxme.sqls.db2.TableSpaceImpl;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class DB2SQLFactoryImpl
extends SQLFactoryImpl
implements DB2SQLFactory {
    public final TableSpace SYSCATSPACE = new PredefinedTableSpace("SYSCATSPACE", TableSpace.Type.REGULAR);
    public final TableSpace TEMPSPACE1 = new PredefinedTableSpace("TEMPSPACE1", TableSpace.Type.SYSTEM_TEMPORARY);
    public final TableSpace USERSPACE1 = new PredefinedTableSpace("USERSPACE1", TableSpace.Type.USER_TEMPORARY);
    private List tableSpaces = new ArrayList();

    public Schema newSchemaImpl(Schema.Name pName) {
        return new DB2SchemaImpl(this, pName);
    }

    public Table newTableImpl(Schema pSchema, Table.Name pName) {
        return new DB2TableImpl(pSchema, pName);
    }

    public Column newColumn(Table pTable, Column.Name pName, Column.Type pType) {
        return new DB2ColumnImpl(pTable, pName, pType);
    }

    public SQLGenerator newSQLGenerator() {
        return new DB2SQLGeneratorImpl();
    }

    public TableSpace newTableSpace(String pName, TableSpace.Type pType) {
        if (pName == null) {
            throw new NullPointerException("The tablespace name must not be null. Use getDefaultTableSpace() to access the default TableSpace.");
        }
        return this.newTableSpace(new TableSpaceImpl.NameImpl(pName), pType);
    }

    public TableSpace newTableSpace(TableSpace.Name pName, TableSpace.Type pType) {
        if (pName == null) {
            throw new NullPointerException("The tablespace name must not be null. Use getDefaultTableSpace() to access the default TableSpace.");
        }
        if (this.getTableSpace(pName) != null) {
            throw new IllegalStateException("A TableSpace named " + pName + " already exists.");
        }
        TableSpace result = this.newTableSpaceImpl(pName, pType);
        this.tableSpaces.add(result);
        return result;
    }

    protected TableSpace newTableSpaceImpl(TableSpace.Name pName, TableSpace.Type pType) {
        return new TableSpaceImpl(this, pName, pType);
    }

    public TableSpace getTableSpace(TableSpace.Name pName) {
        Iterator iter = this.tableSpaces.iterator();
        while (iter.hasNext()) {
            TableSpace tableSpace = (TableSpace)iter.next();
            if (!pName.equals(tableSpace.getName())) continue;
            return tableSpace;
        }
        if (pName.equals(this.SYSCATSPACE.getName())) {
            return this.SYSCATSPACE;
        }
        if (pName.equals(this.TEMPSPACE1.getName())) {
            return this.TEMPSPACE1;
        }
        if (pName.equals(this.USERSPACE1.getName())) {
            return this.USERSPACE1;
        }
        return null;
    }

    public TableSpace getTableSpace(String pName) {
        return this.getTableSpace(new TableSpaceImpl.NameImpl(pName));
    }

    public Iterator getTableSpaces() {
        return this.tableSpaces.iterator();
    }

    public class PredefinedTableSpace
    implements TableSpace {
        private TableSpace.Name name;
        private TableSpace.Type type;

        PredefinedTableSpace(String pName, TableSpace.Type pType) {
            this.name = new TableSpaceImpl.NameImpl(pName);
            this.type = pType;
        }

        public DB2SQLFactory getSQLFactory() {
            return DB2SQLFactoryImpl.this;
        }

        public TableSpace.Name getName() {
            return this.name;
        }

        public TableSpace.Type getType() {
            return this.type;
        }

        public PageSize getPageSize() {
            return null;
        }

        public Long getExtentSize() {
            return null;
        }

        public Long getPrefetchSize() {
            return null;
        }

        public Number getOverhead() {
            return null;
        }

        public Number getTransferRate() {
            return null;
        }

        public Boolean hasDroppedTableRecovery() {
            return null;
        }

        public BufferPool getBufferPool() {
            return null;
        }

        public boolean isPredefined() {
            return true;
        }

        public void setPageSize(PageSize pSize) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public void setExtentSize(Long pSize) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public void setPrefetchSize(Long pSize) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public void setOverhead(Number pOverhead) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public void setTransferRate(Number pNumber) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public void setDroppedTableRecovery(Boolean pRecoverable) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public TableSpace.Container newSystemManagedContainer(String pFile) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public TableSpace.Container newDatabaseManagedContainerInFile(String pFile, long pNumPages) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public TableSpace.Container newDatabaseManagedContainerInDevice(String pDevice, long pNumPages) {
            throw new IllegalStateException("This tablespace is immutable.");
        }

        public Iterator getContainers() {
            return Collections.EMPTY_LIST.iterator();
        }

        public void setBufferPool(BufferPool pBufferPool) {
            throw new IllegalStateException("This tablespace is immutable.");
        }
    }
}

