/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.db2;

import java.util.Iterator;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.db2.BufferPool;
import org.apache.ws.jaxme.sqls.db2.DB2SQLFactory;
import org.apache.ws.jaxme.sqls.db2.PageSize;

public interface TableSpace {
    public DB2SQLFactory getSQLFactory();

    public Name getName();

    public Type getType();

    public PageSize getPageSize();

    public void setPageSize(PageSize var1);

    public Long getExtentSize();

    public void setExtentSize(Long var1);

    public Long getPrefetchSize();

    public void setPrefetchSize(Long var1);

    public Number getOverhead();

    public void setOverhead(Number var1);

    public Number getTransferRate();

    public void setTransferRate(Number var1);

    public Boolean hasDroppedTableRecovery();

    public void setDroppedTableRecovery(Boolean var1);

    public Container newSystemManagedContainer(String var1);

    public Container newDatabaseManagedContainerInFile(String var1, long var2);

    public Container newDatabaseManagedContainerInDevice(String var1, long var2);

    public Iterator getContainers();

    public void setBufferPool(BufferPool var1);

    public BufferPool getBufferPool();

    public boolean isPredefined();

    public static class Type {
        public static final Type REGULAR = new Type("REGULAR");
        public static final Type LONG = new Type("LONG");
        public static final Type SYSTEM_TEMPORARY = new Type("SYSTEM TEMPORARY");
        public static final Type USER_TEMPORARY = new Type("USER TEMPORARY");
        private static final Type[] instances = new Type[]{REGULAR, LONG, SYSTEM_TEMPORARY, USER_TEMPORARY};
        private String name;

        private Type(String pName) {
            this.name = pName;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object pOther) {
            return pOther != null && pOther instanceof Type && this.name.equals(((Type)pOther).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public static Type[] getInstances() {
            return instances;
        }

        public static Type valueOf(String pName) {
            for (int i = 0; i < instances.length; ++i) {
                if (!Type.instances[i].name.equalsIgnoreCase(pName)) continue;
                return instances[i];
            }
            throw new IllegalArgumentException("Invalid type name: " + pName);
        }
    }

    public static interface DatabaseManagedContainer
    extends Container {
        public String getFile();

        public String getDevice();

        public long getNumOfPages();
    }

    public static interface SystemManagedContainer
    extends Container {
        public String getFile();
    }

    public static interface Container {
        public boolean isSystemManaged();

        public boolean isDatabaseManaged();
    }

    public static interface Name
    extends SQLFactory.Ident {
    }
}

