/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.oracle;

import org.apache.ws.jaxme.sqls.BinaryColumn;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ObjectFactory;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.sqls.oracle.OraObjectFactoryImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSQLFactory;
import org.apache.ws.jaxme.sqls.oracle.OraSQLGeneratorImpl;
import org.apache.ws.jaxme.sqls.oracle.OraSelectStatementImpl;

public class OraSQLFactoryImpl
extends SQLFactoryImpl
implements OraSQLFactory {
    public SQLGenerator newSQLGenerator() {
        return new OraSQLGeneratorImpl();
    }

    protected Column readColumn(Table pTable, String pColumnName, int pDataType, String pTypeName, long pColumnSize, int pDecimalDigits, int pNullable) {
        Column.Type type;
        if ("NUMBER".equalsIgnoreCase(pTypeName)) {
            pDataType = 2;
        }
        switch (pDataType) {
            case -5: {
                type = Column.Type.BIGINT;
                break;
            }
            case -2: {
                type = Column.Type.BINARY;
                break;
            }
            case -7: {
                type = Column.Type.BIT;
                break;
            }
            case 2004: {
                type = Column.Type.VARBINARY;
                break;
            }
            case 16: {
                type = Column.Type.BIT;
                break;
            }
            case 1: {
                type = Column.Type.CHAR;
                break;
            }
            case 2005: {
                type = Column.Type.VARCHAR;
                break;
            }
            case 91: {
                type = Column.Type.DATE;
                break;
            }
            case 8: {
                type = Column.Type.DOUBLE;
                break;
            }
            case 6: {
                type = Column.Type.FLOAT;
                break;
            }
            case 4: {
                type = Column.Type.INTEGER;
                break;
            }
            case -4: {
                type = Column.Type.VARBINARY;
                break;
            }
            case -1: {
                type = Column.Type.VARCHAR;
                break;
            }
            case 2: {
                if (pDecimalDigits == 0) {
                    if (pColumnSize == 0L) {
                        type = Column.Type.FLOAT;
                        break;
                    }
                    if (pColumnSize <= 2L) {
                        type = Column.Type.TINYINT;
                        break;
                    }
                    if (pColumnSize <= 4L) {
                        type = Column.Type.SMALLINT;
                        break;
                    }
                    if (pColumnSize <= 9L) {
                        type = Column.Type.INTEGER;
                        break;
                    }
                    type = Column.Type.BIGINT;
                    break;
                }
                if (pDecimalDigits == -127) {
                    if (pColumnSize < 24L) {
                        type = Column.Type.FLOAT;
                        break;
                    }
                    type = Column.Type.DOUBLE;
                    break;
                }
                if (pColumnSize < 8L) {
                    type = Column.Type.FLOAT;
                    break;
                }
                type = Column.Type.DOUBLE;
                break;
            }
            case 1111: {
                if ("CLOB".equalsIgnoreCase(pTypeName)) {
                    type = Column.Type.CLOB;
                    break;
                }
                type = Column.Type.BLOB;
                break;
            }
            case 5: {
                type = Column.Type.SMALLINT;
                break;
            }
            case 93: {
                type = Column.Type.TIMESTAMP;
                break;
            }
            case 92: {
                type = Column.Type.TIME;
                break;
            }
            case -6: {
                type = Column.Type.TINYINT;
                break;
            }
            case -3: {
                type = Column.Type.VARBINARY;
                break;
            }
            case 12: {
                type = Column.Type.VARCHAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Column " + pColumnName + " in table " + pTable.getQName() + " has unknown JDBC data type " + pDataType);
            }
        }
        Column column = pTable.newColumn(pColumnName, type);
        if (column instanceof StringColumn) {
            ((StringColumn)column).setLength(pColumnSize);
        } else if (column instanceof BinaryColumn) {
            ((BinaryColumn)column).setLength(pColumnSize);
        }
        if (pNullable == 1) {
            column.setNullable(true);
        }
        return column;
    }

    protected ObjectFactory newObjectFactory() {
        return new OraObjectFactoryImpl();
    }

    public SelectStatement newSelectStatement() {
        return new OraSelectStatementImpl(this);
    }
}

